/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String DF_YYYYMMDD = "yyyyMMdd";
    public static final String DF_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DF_YYYY_MM = "yyyyMM";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
    private static SimpleDateFormat stp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static boolean nowTimeIsInsideTargetTime(String startTime, String endTime) {
        try {
            Date stime = stp.parse(startTime);
            Date etime = stp.parse(endTime);
            Calendar nowDate = Calendar.getInstance();
            nowDate.setTime(new Date());
            Calendar st = Calendar.getInstance();
            st.setTime(stime);
            Calendar et = Calendar.getInstance();
            et.setTime(etime);
            return nowDate.after(st) && nowDate.before(et);
        }
        catch (ParseException e) {
            log.info("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean sixMonth(String startTime, String endTime, Integer count) {
        Date startDate = null;
        Date endDate = null;
        boolean flag = false;
        try {
            startDate = stp.parse(startTime);
            endDate = stp.parse(endTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(2, count);
            String time = stp.format(calendar.getTime());
            log.info("\u516d\u6708\u540e\u65f6\u95f4={}", (Object)time);
            if (stp.parse(time).after(endDate) || stp.parse(time).equals(endDate)) {
                flag = true;
            }
        }
        catch (ParseException e) {
            log.info("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38;{}", (Object)e.getMessage());
        }
        return flag;
    }

    public static String getLast12Months(int i, String t) {
        Date parse = new Date();
        try {
            parse = stp.parse(t);
        }
        catch (ParseException e) {
            log.info("\u65f6\u95f4\u8f6c\u5316\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f={}", (Object)e.getMessage());
        }
        Calendar c = Calendar.getInstance();
        c.setTime(parse);
        c.add(2, -i);
        Date m = c.getTime();
        return sdf.format(m);
    }

    public static int getDayOfMonth(String month) {
        try {
            Date nowDate = sdf.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.set(5, calendar.getActualMaximum(5));
            int i = calendar.get(5);
            return i;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Date getMaxDateMonth(String month) {
        try {
            Date nowDate = sdf.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.set(5, calendar.getActualMaximum(5));
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getMinDateMonth(String month) {
        try {
            Date nowDate = sdf.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.set(5, calendar.getActualMinimum(5));
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getBeforeMonthDay() {
        Calendar a = Calendar.getInstance();
        a.add(2, -1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getCurrentMonthDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static String getBeforeMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        int minimum = calendar.getActualMinimum(5);
        calendar.set(5, minimum);
        Date time = calendar.getTime();
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time);
    }

    public static String getBeforeMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        int maximum = calendar.getActualMaximum(5);
        calendar.set(5, maximum);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime());
    }

    public static Date getToday() {
        return new Date();
    }

    public static Date getYesterday() {
        return DateUtil.getDayBefore(1);
    }

    public static Date getDayBefore(int dayNum) {
        Date date = new Date(new Date().getTime() - (long)(dayNum * 24 * 60 * 60) * 1000L);
        return date;
    }

    public static Date getStartTime(Date date) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(date);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getEndTime(Date date) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.setTime(date);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static String getDayStartTimeStr(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(11, 0);
        dateStart.set(12, 0);
        dateStart.set(13, 0);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dateStart.getTime());
    }

    public static String getDayEndTimeStr(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(11, 23);
        dateStart.set(12, 59);
        dateStart.set(13, 59);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dateStart.getTime());
    }

    public static int getIntDay() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DF_YYYYMMDD);
        return Integer.valueOf(df.format(now));
    }

    public static int getIntDay(Date date) {
        if (null == date) {
            return DateUtil.getIntDay();
        }
        SimpleDateFormat df = new SimpleDateFormat(DF_YYYYMMDD);
        return Integer.valueOf(df.format(date));
    }

    public static String getStrDay(String fmt) {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        return df.format(now);
    }

    public static String getStrDay(Date date, String fmt) {
        if (null == date) {
            return DateUtil.getStrDay(fmt);
        }
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        return df.format(date);
    }

    public static Date str2date(String timeStr, String fmt) {
        if (StringUtils.isBlank((CharSequence)timeStr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        Date date = null;
        try {
            date = df.parse(timeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getBeforeDate(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, -1);
        return ca.getTime();
    }

    public static String parseMin(Integer seconds) {
        String parse = "";
        try {
            if (seconds < 60) {
                parse = seconds + "\u79d2";
            } else if (seconds >= 60 && seconds < 3600) {
                Integer minutes = seconds / 60;
                Integer remainingSeconds = seconds % 60;
                parse = minutes + "\u5206" + remainingSeconds + "\u79d2";
            } else {
                Integer hour = seconds / 3600;
                Integer minutes = seconds % 3600 / 60;
                Integer remainingSeconds = seconds % 60;
                parse = hour + "\u5c0f\u65f6" + minutes + "\u5206" + remainingSeconds + "\u79d2";
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:" + e);
            e.printStackTrace();
        }
        return parse;
    }

    public static String getDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    public static Boolean checkTimeSpan(String startTime, String endTime, Integer span) {
        SimpleDateFormat format = new SimpleDateFormat(DF_YYYY_MM_DD);
        Calendar startTimeCal = Calendar.getInstance();
        Calendar endTimeCal = Calendar.getInstance();
        try {
            startTimeCal.setTime(format.parse(startTime));
            endTimeCal.setTime(format.parse(endTime));
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u9519\u8bef");
            e.printStackTrace();
        }
        endTimeCal.add(2, -span.intValue());
        if (startTimeCal.before(endTimeCal)) {
            log.info("\u65f6\u95f4\u8de8\u5ea6\u8d85\u8fc7{}\u4e2a\u6708", (Object)span);
            return false;
        }
        return true;
    }

    public static Integer getIntDate(Date dataTime) {
        SimpleDateFormat format = new SimpleDateFormat(DF_YYYYMMDD);
        String dataTineStr = format.format(dataTime);
        Integer dataTimeInt = Integer.parseInt(dataTineStr);
        return dataTimeInt;
    }

    public static String getYyyyMmDate(Date dataTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String dataTineStr = format.format(dataTime);
        return dataTineStr;
    }
}

