/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils;

import com.alibaba.excel.EasyExcel;
import com.tydic.nicc.ocs.bo.OcsUploadReqBO;
import com.tydic.nicc.ocs.service.OCSFileService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExcelHelper {
    private static final Logger log = LoggerFactory.getLogger(ExcelHelper.class);
    @Value(value="${file.path.local:/tmp/}")
    private String localPath;
    @Resource
    private OCSFileService ocsFileService;

    public String writeExcel(List list, Class clazz) {
        String filePath = this.localPath + System.currentTimeMillis() + ".xlsx";
        this.writeExcelFile(list, filePath, clazz);
        return filePath;
    }

    public String writeExcel(List list, Class clazz, String fileName) {
        String filePath = this.localPath + fileName + ".xlsx";
        this.writeExcelFile(list, filePath, clazz);
        return filePath;
    }

    public String writeExcel(List list, String fileDir, String fileName, Class clazz) {
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            String filePath = fileDir + File.separator + fileName;
            this.writeExcelFile(list, filePath, clazz);
            return filePath;
        }
        log.error("\u6587\u4ef6\u540d\u79f0\u53ea\u80fd\u4e3aexcel\u683c\u5f0f\uff01");
        return "";
    }

    public String writeExcelFile(List list, String filePath, Class clazz) {
        File f = new File(filePath);
        if (!f.exists()) {
            try {
                log.info("\u5c06\u5bfc\u51fa {} \u6761\u6570\u636e ,\u6587\u4ef6\u8def\u5f84:{}", (Object)list.size(), (Object)filePath);
                f.createNewFile();
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u521b\u5efa\u5931\u8d25:{}", (Object)e.getMessage());
                return "";
            }
        }
        EasyExcel.write((String)filePath, (Class)clazz).sheet("\u6570\u636e\u8868").doWrite(list);
        OcsUploadReqBO fileBO = new OcsUploadReqBO();
        fileBO.setUploadFileName(f.getName());
        fileBO.setUploadPath(filePath);
        this.ocsFileService.ocsUpload(fileBO);
        return f.getName();
    }
}

