/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String url, MultipartFile file, String data) {
        String result = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("multipartFile", file.getInputStream(), ContentType.MULTIPART_FORM_DATA, file.getOriginalFilename());
            Map map = (Map)JSON.parse((String)data);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entity = obj = iterator.next();
                builder.addTextBody((String)entity.getKey(), (String)((JSONArray)entity.getValue()).get(0));
            }
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("UTF-8"));
                log.info("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            }
        }
        catch (IOException e) {
            log.error("upload file err:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static MultipartFile fileToMultipartFile(File file) {
        FileItem fileItem = FileUtil.createFileItem(file);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        return multipartFile;
    }

    private static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }
}

