/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5CheckUtils {
    protected char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected MessageDigest messagedigest = null;

    public MD5CheckUtils() {
        try {
            this.messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public String getFileMD5String(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int numRead = 0;
        while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
            this.messagedigest.update(buffer, 0, numRead);
        }
        ((InputStream)fis).close();
        return this.bufferToHex(this.messagedigest.digest());
    }

    public String getFileMD5String(InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        int numRead = 0;
        while ((numRead = in.read(buffer)) > 0) {
            this.messagedigest.update(buffer, 0, numRead);
        }
        in.close();
        return this.bufferToHex(this.messagedigest.digest());
    }

    private String bufferToHex(byte[] bytes) {
        return this.bufferToHex(bytes, 0, bytes.length);
    }

    private String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            this.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = this.hexDigits[(bt & 0xF0) >> 4];
        char c1 = this.hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }
}

