/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils.es;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.bo.CallRecordBO;
import com.tydic.nicc.ocs.bo.ObCallRecordElasticsearchBO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.boot.BBossESStarter;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentCRUD<T> {
    private static final Logger log = LoggerFactory.getLogger(DocumentCRUD.class);
    @Autowired
    private BBossESStarter bbossESStarter;
    private static final String RECORD_MAPPER = "esmapper/call-record.xml";
    private static final String SEARCH_PATH = "ob_call_record/_search";

    public Long qryCallRecordCase(Map<String, Object> params) {
        ClientInterface clientUtil = this.bbossESStarter.getConfigRestClient(RECORD_MAPPER);
        ESDatas esDatas = clientUtil.searchList(SEARCH_PATH, "qryTaskCallRecordCase", params, ObCallRecordElasticsearchBO.class);
        return esDatas.getTotalSize();
    }

    public List<ObCallRecordPO> qryCallRecordByHour(Map<String, Object> params) {
        ClientInterface clientUtil = this.bbossESStarter.getConfigRestClient(RECORD_MAPPER);
        ArrayList<ObCallRecordPO> recordPOS = new ArrayList<ObCallRecordPO>();
        ESDatas esDatas = clientUtil.searchList(SEARCH_PATH, "qryCallRecordByHour", params, ObCallRecordElasticsearchBO.class);
        Map aggregations = esDatas.getAggregations();
        Map groupByHour = (Map)aggregations.get("group_by_hour");
        if (null == groupByHour || groupByHour.size() == 0) {
            return recordPOS;
        }
        Object buckets = groupByHour.get("buckets");
        if (null == buckets) {
            return recordPOS;
        }
        List maps = JSONArray.parseArray((String)JSONObject.toJSONString(buckets), JSONObject.class);
        for (JSONObject map : maps) {
            ObCallRecordPO recordPO = new ObCallRecordPO();
            String obHour = (String)map.getObject("key", String.class);
            Long callCount = (Long)map.getObject("doc_count", Long.class);
            Object isConnCountMap = map.get((Object)"is_conn_count");
            Long isConnCount = this.getMapNumber(isConnCountMap);
            Object isNotConnCountMap = map.get((Object)"is_not_conn_count");
            Long isNotConnCount = this.getMapNumber(isNotConnCountMap);
            Object obsIsConnCountMap = map.get((Object)"obs_is_conn_count");
            Long obsIsConnCount = this.getMapNumber(obsIsConnCountMap);
            recordPO.setObHour(obHour);
            recordPO.setCallCount(callCount);
            recordPO.setIsConnCount(isConnCount);
            recordPO.setIsNotConnCount(isNotConnCount);
            recordPO.setObsIsConnCount(obsIsConnCount);
            recordPOS.add(recordPO);
        }
        return recordPOS;
    }

    private Long getMapNumber(Object param) {
        long number = 0L;
        if (null == param) {
            return number;
        }
        JSONObject map = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)param), JSONObject.class);
        Object countObj = map.get((Object)"doc_count");
        return Long.parseLong(String.valueOf(countObj));
    }

    public List<CallRecordBO> qryCallHistory(Map<String, Object> param) {
        ClientInterface clientUtil = this.bbossESStarter.getConfigRestClient(RECORD_MAPPER);
        ArrayList<CallRecordBO> recordBOS = new ArrayList<CallRecordBO>();
        ESDatas esDatas = clientUtil.searchList(SEARCH_PATH, "qryCallHistory", param, ObCallRecordElasticsearchBO.class);
        long totalSize = esDatas.getTotalSize();
        List datas = esDatas.getDatas();
        if (null != datas && datas.size() > 0) {
            for (ObCallRecordElasticsearchBO bo : datas) {
                CallRecordBO recordBO = new CallRecordBO();
                recordBO.setCalling(bo.getCalling());
                recordBO.setCalled(bo.getCalled());
                recordBO.setIsConn(bo.getIs_conn());
                recordBO.setObsIsConn(bo.getObs_is_conn());
                recordBO.setContactLength(bo.getContact_length());
                recordBO.setStartTime(bo.getStart_time());
                recordBO.setEndTime(bo.getEnd_time());
                recordBO.setHandleResults(bo.getHandle_results());
                recordBO.setTotal(Long.valueOf(totalSize));
                recordBO.setAccount(bo.getAccount());
                recordBOS.add(recordBO);
            }
        }
        return recordBOS;
    }
}

