package com.tydic.dyc.oc.service.domainservice.bo;


import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocAfOrderCommodityItemBo
 * 说明:售后单商品明细信息
 * 时间:2022/2/14 13:46
 * 作者:tkl
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocAfOrderCommodityItemBo implements Serializable {
    private static final long serialVersionUID = 4144683818587785831L;

    /**
     * 售后服务单id
     */
    private Long afOrderId;

    /**
     * 服务明细id
     */
    private Long afOrderItemId;

    /**
     * 订单明细id
     */
    private Long orderItemId;

    /**
     * 售后中数量
     */
    private BigDecimal afterServingCount;

    /**
     * 已退货数量
     */
    private BigDecimal alreadyReturnCount;

    /**
     * 验收明细id
     */
    private Long inspOrderItemId;

    /**
     * 验收数量
     */
    private BigDecimal inspCount;

    /**
     * 发货单id
     */
    private Long shipOrderId;

    /**
     * 发货单编码
     */
    private String shipOrderNo;

    /**
     * 发货明细id
     */
    private Long shipOrderItemId;

    /**
     * 发货工号
     */
    private String shipOperId;

    /**
     * 发货联系人姓名
     */
    private String shipName;

    /**
     * 发货联系人电话
     */
    private String shipPhone;

    /**
     * 发货单状态
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocStateConstants.ShipOrder.P_CODE)
    private String shipOrderState;

    /**
     * 发货单状态翻译
     */
    private String shipOrderStateStr;

    /**
     * 发货时间
     */
    private Date shipTime;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * sku物料编码
     */
    private String skuMaterialId;

    /**
     * sku物料名称
     */
    private String skuMaterialName;

    /**
     * sku物料类型id
     */
    private String skuMaterialTypeId;

    /**
     * sku物料类型名称
     */
    private String skuMaterialTypeName;

    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;

    /**
     * sku单品主图url
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.ORDER_SOURCE.P_CODE)
    private Integer skuSource;

    /**
     * sku来源翻译
     */
    private String skuSourceStr;

    /**
     * 销售价格
     */
    private BigDecimal salePrice;

    /**
     * 税率
     */
    private String tax;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 发货数量
     */
    private BigDecimal sendCount;

    /**
     * 采购名称
     */
    private String purName;

    /**
     * 销售退款金额
     */
    private BigDecimal retSaleFee;

    /**
     * 采购退款金额
     */
    private BigDecimal retPurchaseFee;

    /**
     * 售后数量
     */
    private BigDecimal returnCount;

    /**
     * 可售后数量
     */
    private BigDecimal availableAfterServCount;

    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 销售单id
     */
    private Long saleOrderItemId;

    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;
    /**
     * 配送单号
     */
    private String shipCompanyNo;
    /**
     * 计量单位
     */
    private String unitDigit;
}
