package com.tydic.dyc.oc.service.domainservice.bo;


import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 标题:UocQryChngOrderDetailsRspInfoAgreementDataBo
 * 说明:协议信息
 * 时间:2022-02-21 19:11
 * 作者:tkl
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryChngOrderDetailsRspInfoAgreementDataBo implements Serializable {
    private static final long serialVersionUID = 4701693053253381642L;

    //平台协议编号")
    private String plaAgreementCode;

    //企业协议编号")
    private String entAgreementCode;

    //协议名称")
    private String agreementName;

    //协议经办人名字")
    private String producerName;

    //协议模式 1：平台协议 2：单位协议")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.AGREEMENT_MODE.P_CODE)
    private Integer agreementCode;

    //协议模式翻译")
    private String agreementCodeStr;

    //调价机制")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.ADJUST_PRICE.P_CODE)
    private Integer adjustPrice;

    //调价机制翻译")
    private String adjustPriceStr;
}
