package com.tydic.dyc.oc.service.common.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocOutLogSaveServiceReqBo
 * 说明:
 * 时间:2023/7/25 9:12
 * 作者:田桂银
 */
@Data
public class UocOutLogSaveServiceReqBo implements Serializable {

    private static final long serialVersionUID = -7692943369010989327L;


    /**
     * 系统类型，1内部系统，2外部系统（必传），枚举值：com.tydic.dyc.oc.constants.UocOutLogConstant.SYSTEM_TYPE
     */
    private Integer systemType;
    /**
     * 日志方向，1正向日志，2回滚日志（必传），枚举值：com.tydic.dyc.oc.constants.UocOutLogConstant.LOG_TYPE
     */
    private Integer logType;
    /**
     * 日志类型，1成功日志，2失败日志（必传），枚举值：com.tydic.dyc.oc.constants.UocOutLogConstant.LOG_FLAG
     */
    private Integer logFlag;
    /**
     * 分库键对象id（必传）
     */
    private Long partitionObjId;
    /**
     * 业务对象id
     */
    private Long busiObjId;
    /**
     * 业务对象类型，枚举值见：UocDicConstant.OBJ_TYPE
     */
    private Integer busiObjType;
    /**
     * 业务场景类型，枚举值见：UocOutLogConstant.BUSI_TYPE
     */
    private Integer busiType;
    /**
     * 发起调用服务类（记录类名）
     */
    private String sendService;
    /**
     * 被调用服务类（记录类名）
     */
    private String callService;
    /**
     * 入参（必传）
     */
    private String reqParam;
    /**
     * 出参
     */
    private String rspParam;
    /**
     * 创建时间，外传（对应业务发生时间，根据业务排序）（必传）
     */
    private Date createTime;
    /**
     * 涉及金额
     */
    private BigDecimal amount;

}


