package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：UocAfOrderServiceInfoBo
 *
 * @author tkl
 * @date 2022/2/13 22:01
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocAfOrderServiceInfoBo implements Serializable {
    private static final long serialVersionUID = -212809246518383750L;

    /**
     * 服务单编号
     */
    private String afServCode;
    /**
     * 外部售后单ID
     */
    private String afsServiceId;

    /**
     * 是否付过款
     */
    private Boolean isPayFlag = false;

    /**
     * 服务单状态  100提交申请  200 审核中 201审核不通过 300收货完成  400退款成功 401退款失败 500 已完成  600 取消
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.SERVICE_STATE.P_CODE)
    private Integer servState;

    /**
     * 服务单状态翻译
     */
    private String servStateStr;

    /**
     * 供应商Id
     */
    private String supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 服务单类型  退货(10) 换货(20)  维修(30)
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.SERVICE_TYPE.P_CODE)
    private Integer servType;

    /**
     * 服务单类型翻译
     */
    private String servTypeStr;

    /**
     * 申请人
     */
    private String submitterOperName;

    /**
     * 服务提出联系人
     */
    private String subContactName;

    /**
     * 服务提出联系人电话
     */
    private String subContactMobile;

    /**
     * 申请时间
     */
    private Date submiteTime;

    /**
     * 取件开始时间
     */
    private Date pickupStartTime;

    /**
     * 取件结束时间
     */
    private Date pickupEndTime;

    /**
     * 售后完成时间
     */
    private Date finishTime;

    /**
     * 供应商确认时间
     */
    private Date confirmTime;

    /**
     * 支付方式  1 预付款 2 电汇或承兑汇票
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.PAY_TYPE.P_CODE)
    private String payType;

    /**
     * 支付方式翻译
     */
    private String payTypeStr;

    /**
     * 售后原因
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.AFS_REASON.P_CODE)
    private Integer afsReason;

    /**
     * 售后原因翻译
     */
    private String afsReasonStr;

    /**
     * 问题描述
     */
    private String questionDesc;

    /**
     * 外部订单id
     */
    private String outOrderId;

    /**
     * 外部订单编号
     */
    private String outOrderNo;

    /**
     * 订单类型
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.VENDOR_ORD_TYPE.P_CODE)
    private Integer orderType;

    /**
     * 订单类型翻译
     */
    private String orderTypeStr;

    /**
     * 取货服务类型  1：  上门取件  2：客户发货  3：  客户送货
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE)
    private Integer pickwareType;

    /**
     * 取货服务类型翻译
     */
    private String pickwareTypeStr;

    /**
     * 取件地址信息
     */
    private UocAfOrderReceiverAddressBo orderTakeDeliveryInfo;

    /**
     * 收货地址信息
     */
    private UocAfOrderReceiverAddressBo orderTakeReceiveInfo;

    /**
     * 附件信息
     */
    private List<UocBaseOrderAccessoryTypeDetailBo> accessoryInfo;

    /**
     * 任务ID
     */
    private String taskId;


    /**
     * 环节编码
     */
    private String stepId;
    /**
     * 客户姓名
     */
    private String clientName;

    /**
     * 手机号
     */
    private String clientPhone;

    /**
     * 下单人
     */
    private String purName;

    private String purUserId;

    private String purOrgId;
    
    //电商收货地址信息
    private UocAfOrderReceiverAddressBo esReceiveInfo;
    
    private String extAfId;
    
    private Long saleOrderId;

    private String saleOrderNo;

    private Date orderCreateTime;
    //销售退款总金额")
    private BigDecimal retTotalSaleFee;
}


