/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfItemMapQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderMapQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfItemMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncAf
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncAf.class);
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getAfOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocAfOrder afOrderMain = this.getAfOrderMain(reqBo);
        if (ObjectUtil.isNull((Object)afOrderMain)) {
            return rspBo;
        }
        List<UocAfOrderMap> afOrderMapList = this.getAfOrderMapList(reqBo);
        List<UocAfOrderObj> afOrderObjList = this.getAfOrderObjList(reqBo);
        for (UocAfOrderObj uocAfOrderObj : afOrderObjList) {
            if (!ObjectUtil.isNotEmpty((Object)uocAfOrderObj.getInspOrderId())) continue;
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setInspOrderId(uocAfOrderObj.getInspOrderId());
            uocInspOrderQryBo.setOrderId(uocAfOrderObj.getOrderId());
            UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            uocAfOrderObj.setInspOrderNo(uocInspOrderDo.getInspOrderNo());
        }
        List<UocAfOrderItem> afOrderItemList = this.getAfOrderItemList(reqBo);
        List<UocAfItemMap> afOrderItemMapList = this.getAfOrderItemMapList(reqBo);
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(afOrderMain);
        Map<Long, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSaleOrderItemId));
        ConcurrentMap<Object, Object> afItemMap = new ConcurrentHashMap();
        if (ObjectUtil.isNotEmpty(afOrderItemMapList)) {
            afItemMap = afOrderItemMapList.stream().collect(Collectors.groupingByConcurrent(UocAfItemMap::getAfOrderItemId));
        }
        List<UocOrderAccessory> orderAccessoryList = this.getOrderAccessoryList(reqBo);
        UocAfOrderDo uocAfOderDo = UocRu.js(afOrderMain, UocAfOrderDo.class);
        UocGetSaleOrderDetailServiceRspPorcBo procInst = this.getProcInst(uocAfOderDo, false);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.ORDER);
        this.translateAfMain(uocAfOderDo);
        uocAfOderDo.setAfOrderObjList(afOrderObjList);
        uocAfOderDo.setOrderAccessoryBoList(orderAccessoryList);
        UocSaleOrderDo saleOrderDo = this.getSaleOrderDo(uocAfOderDo);
        Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(uocAfOderDo);
        List<UocShipOrderDo> shipOrderDos = this.getShipOrderDo(uocAfOderDo);
        if (1 == saleOrderDo.getOrderSource() || 3 == saleOrderDo.getOrderSource()) {
            DictFrameworkUtils.translateByAnnotation((Object)uocAfOderDo);
        }
        JSONObject afOrderObj = JSON.parseObject((String)JSON.toJSONString((Object)uocAfOderDo));
        this.putShipOrderInfo(shipOrderDos, afOrderObj);
        this.putSaleOrderInfo(saleOrderDo, afOrderObj);
        if (ObjectUtil.isNotEmpty(afOrderMapList)) {
            afOrderMapList.forEach(each -> afOrderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        JSONArray afItemArray = new JSONArray();
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            afOrderObj.put("returnCount", (Object)afOrderItemList.stream().map(UocAfOrderItem::getReturnCount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).intValue());
            afOrderObj.put("returnCountStr", (Object)new DecimalFormat("0.00#").format(afOrderItemList.stream().map(UocAfOrderItem::getReturnCount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            for (UocAfOrderItem item : afOrderItemList) {
                List<UocSaleOrderItem> uocSaleOrderItems;
                UocSaleOrderItem saleOrderItem;
                this.translateAfItem(item);
                JSONObject afItemObj = JSON.parseObject((String)JSON.toJSONString((Object)item));
                if (ObjectUtil.isNotEmpty(afItemMap) && afItemMap.containsKey(item.getAfOrderItemId())) {
                    ((List)afItemMap.get(item.getAfOrderItemId())).forEach(each -> afItemObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
                }
                if (ObjectUtil.isNotEmpty(saleItemMap) && saleItemMap.containsKey(item.getSaleItemId())) {
                    this.putSaleItemInfo(afItemObj, saleItemMap.get(item.getSaleItemId()));
                }
                if ((saleOrderItem = (uocSaleOrderItems = saleOrderItemMap.get(item.getSaleItemId())).get(0)) != null) {
                    afItemObj.put("unitDigit", (Object)saleOrderItem.getUnitDigit());
                }
                afItemArray.add((Object)afItemObj);
            }
            log.info("afItemArray:" + JSON.toJSONString((Object)afItemArray));
        }
        afOrderObj.put("afOrderItemBoList", (Object)afItemArray);
        afOrderObj.put("busiTaskList", (Object)procInst.getTaskList());
        afOrderObj.put("busiProcInstId", (Object)procInst.getProcInstId());
        afOrderObj.put("auditProcInstId", (Object)auditProcInst.getProcInstId());
        afOrderObj.put("afterFlag", (Object)true);
        afOrderObj.put("afterDetailFlag", (Object)true);
        this.putDoneTask(uocAfOderDo, afOrderObj);
        if (Integer.valueOf(1).equals(afOrderMain.getWaybillFlag())) {
            afOrderObj.put("waybillFlagStr", (Object)"\u662f");
        } else {
            afOrderObj.put("waybillFlagStr", (Object)"\u5426");
        }
        afOrderObj.put("contactShipName", (Object)this.getLogistics(afOrderMain));
        rspBo.setJsonObj(afOrderObj);
        log.info("\u552e\u540e\u5355ES\u6570\u636e\uff1a{}", (Object)afOrderObj.toJSONString());
        return rspBo;
    }

    private void putDoneTask(UocAfOrderDo uocAfOderDo, JSONObject afOrderObj) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(uocAfOderDo.getAfOrderId());
        taskInstQryBo.setOrderId(uocAfOderDo.getOrderId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        ArrayList<Integer> finishTagList = new ArrayList<Integer>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        taskInstQryBo.setFinishTagList(finishTagList);
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            List procState = uocOrderTaskInsts.stream().map(UocOrderTaskInst::getStepCode).collect(Collectors.toList());
            afOrderObj.put("doneTaskTacheCode", procState);
        }
    }

    private void putShipOrderInfo(List<UocShipOrderDo> shipOrderDos, JSONObject afOrderObj) {
        if (ObjectUtil.isNotEmpty(shipOrderDos)) {
            afOrderObj.put("shipOrderNo", (Object)shipOrderDos.get(0).getShipOrderNo());
            afOrderObj.put("shipOrderStateStr", DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"SHIP_ORDER_STATE", (String)shipOrderDos.get(0).getShipOrderState()) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"SHIP_ORDER_STATE", (String)shipOrderDos.get(0).getShipOrderState()).getValue());
        }
    }

    private void putSaleOrderInfo(UocSaleOrderDo saleOrderDo, JSONObject afOrderObj) {
        if (ObjectUtil.isNotEmpty((Object)((Object)saleOrderDo))) {
            afOrderObj.put("orderSource", (Object)saleOrderDo.getOrderSource().toString());
            afOrderObj.put("orderCreateOperName", (Object)saleOrderDo.getCreateOperName());
            afOrderObj.put("orderCreateTime", (Object)saleOrderDo.getCreateTime());
            afOrderObj.put("saleOrderId", (Object)saleOrderDo.getSaleOrderId());
            afOrderObj.put("saleOrderNo", (Object)saleOrderDo.getSaleOrderNo());
            afOrderObj.put("saleOrderState", (Object)saleOrderDo.getSaleOrderState());
            afOrderObj.put("saleOrderStateStr", DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"UOC_SALE_ORDER_STATE", (String)saleOrderDo.getSaleOrderState()) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"UOC_SALE_ORDER_STATE", (String)saleOrderDo.getSaleOrderState()).getValue());
            afOrderObj.put("tradeMode", (Object)saleOrderDo.getModelSettle());
            if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getStakeholder())) {
                afOrderObj.put("supId", (Object)saleOrderDo.getStakeholder().getSupId());
                afOrderObj.put("purOrgId", (Object)saleOrderDo.getStakeholder().getPurOrgId());
                afOrderObj.put("purOrgName", (Object)saleOrderDo.getStakeholder().getPurOrgName());
                afOrderObj.put("purCompanyId", (Object)saleOrderDo.getStakeholder().getPurCompanyId());
                afOrderObj.put("purCompanyName", (Object)saleOrderDo.getStakeholder().getPurCompanyName());
                afOrderObj.put("supNo", (Object)saleOrderDo.getStakeholder().getSupId());
                afOrderObj.put("supName", (Object)saleOrderDo.getStakeholder().getSupName());
                afOrderObj.put("purUserId", (Object)saleOrderDo.getStakeholder().getPurUserId());
                afOrderObj.put("proId", (Object)saleOrderDo.getStakeholder().getProId());
                afOrderObj.put("purOrgPath", (Object)saleOrderDo.getStakeholder().getPurOrgPath());
                afOrderObj.put("supOrgPath", (Object)saleOrderDo.getStakeholder().getSupOrgPath());
                afOrderObj.put("proOrgPath", (Object)saleOrderDo.getStakeholder().getProOrgPath());
            }
        }
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocAfOrder afOrderMain) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(afOrderMain.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(afOrderMain.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private void translateAfItem(UocAfOrderItem item) {
        DictFrameworkUtils.translateByAnnotation((Object)item);
    }

    private void translateAfMain(UocAfOrderDo uocAfOderDo) {
        DictFrameworkUtils.translateByAnnotation((Object)uocAfOderDo);
    }

    private List<UocOrderAccessory> getOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(reqBo.getObjId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    private String getLogistics(UocAfOrder uocAfOrder) {
        UocOrdLogisticsRela logisticsRela = new UocOrdLogisticsRela();
        if (null != uocAfOrder) {
            UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setOrderId(uocAfOrder.getOrderId());
            UocOrderDo uocOrderDo = this.getUocOrderDo(uocAfOrder.getOrderId());
            relaQryBo.setContactId(uocOrderDo.getContactId());
            logisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        }
        return logisticsRela.getContactName();
    }

    private UocOrderDo getUocOrderDo(Long orderId) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryOrderBy(qryBo);
    }

    private List<UocShipOrderDo> getShipOrderDo(UocAfOrderDo uocAfOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(uocAfOrderDo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(uocAfOrderDo.getSaleOrderId());
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private List<UocShipOrderItem> getListShipOrderItem(UocSaleOrderItem reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setSaleOrderItemId(reqBo.getSaleOrderItemId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return ObjectUtil.isNotNull((Object)uocShipOrderDo) ? uocShipOrderDo.getShipOrderItemBoList() : new ArrayList<UocShipOrderItem>();
    }

    private void putSaleItemInfo(JSONObject afItemObj, UocSaleOrderItem uocSaleOrderItem) {
        afItemObj.put("commodityId", (Object)uocSaleOrderItem.getCommodityId());
        afItemObj.put("commodityName", (Object)uocSaleOrderItem.getCommodityName());
        afItemObj.put("skuName", (Object)uocSaleOrderItem.getSkuName());
        afItemObj.put("skuId", (Object)uocSaleOrderItem.getSkuId());
        afItemObj.put("skuCode", (Object)uocSaleOrderItem.getSkuCode());
        afItemObj.put("skuExtSkuId", (Object)uocSaleOrderItem.getSkuExtSkuId());
        afItemObj.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuMaterialId());
        afItemObj.put("skuMaterialCode", (Object)uocSaleOrderItem.getSkuMaterialCode());
        afItemObj.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuMainPicUrl());
        afItemObj.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
        afItemObj.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
        afItemObj.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
        afItemObj.put("unitName", (Object)uocSaleOrderItem.getUnitName());
        afItemObj.put("model", (Object)uocSaleOrderItem.getModel());
        afItemObj.put("spec", (Object)uocSaleOrderItem.getSpec());
        afItemObj.put("tax", (Object)uocSaleOrderItem.getTax());
        afItemObj.put("taxId", (Object)uocSaleOrderItem.getTaxId());
        afItemObj.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
        afItemObj.put("skuBrandId", (Object)uocSaleOrderItem.getSkuBrandId());
        afItemObj.put("skuBrandName", (Object)uocSaleOrderItem.getSkuBrandName());
        afItemObj.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
        afItemObj.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
        afItemObj.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
        afItemObj.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
        afItemObj.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
        afItemObj.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
        afItemObj.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
        afItemObj.put("supplierId", (Object)uocSaleOrderItem.getSupplierId());
        afItemObj.put("supplierShopId", (Object)uocSaleOrderItem.getSupplierShopId());
        List<UocShipOrderItem> shipOrderItemList = this.getListShipOrderItem(uocSaleOrderItem);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            afItemObj.put("saleFee", (Object)uocSaleOrderItem.getSalePrice().multiply(shipOrderItemList.get(0).getSendCount()));
            afItemObj.put("purFee", (Object)uocSaleOrderItem.getPurchasePrice().multiply(shipOrderItemList.get(0).getSendCount()));
        }
        afItemObj.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
        afItemObj.put("purchaseCount", (Object)uocSaleOrderItem.getPurchaseCount());
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o, (k1, k2) -> k2));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private UocSaleOrderDo getSaleOrderDo(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
        return ObjectUtil.isNotEmpty(uocSaleOrderDos) ? uocSaleOrderDos.get(0) : null;
    }

    private List<UocAfOrderObj> getAfOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    private List<UocAfOrderItem> getAfOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    private List<UocAfItemMap> getAfOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfItemMapQryBo uocAfItemMapQryBo = new UocAfItemMapQryBo();
        uocAfItemMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    private List<UocAfOrderMap> getAfOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderMapQryBo uocAfOrderMapQryBo = new UocAfOrderMapQryBo();
        uocAfOrderMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    private UocAfOrder getAfOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocAfOrderDo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getAfOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjId(reqBo.getOrderId() + "");
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    ArrayList<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<UocOrderTaskDeal>();
                    UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
                    BeanUtils.copyProperties((Object)each, (Object)uocOrderTaskDeal);
                    uocOrderTaskDeal.setDealId(each.getTaskUserId().toString());
                    uocOrderTaskDeal.setDealName(each.getTaskUserName());
                    uocOrderTaskDeals.add(uocOrderTaskDeal);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDea = (UocOrderTaskDeal)uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDea.getDealId();
                        String dealName = uocOrderTaskDea.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                    Date finishTime = each.getFinishTime();
                    String dealId = each.getDealId();
                    if (ObjectUtil.isNotEmpty((Object)finishTime) && ObjectUtil.isNotEmpty((Object)dealId)) {
                        each.setFinishTimeStr(dealId + objBusiType + finishTime.getTime());
                    }
                });
                procInst.setTaskList(taskBoList);
                procInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
            }
        }
        return procInst;
    }
}

