/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.UocBargainingDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingProgressRecordDo;
import com.tydic.dyc.oc.model.bargaining.UocBargainingQuotationDo;
import com.tydic.dyc.oc.service.bargaining.UocResolveBargainingApplyService;
import com.tydic.dyc.oc.service.bargaining.bo.UocResolveBargainingApplyReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocResolveBargainingApplyRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.bargaining.UocResolveBargainingApplyService"})
public class UocResolveBargainingApplyServiceImpl
implements UocResolveBargainingApplyService {
    private static final Logger log = LoggerFactory.getLogger(UocResolveBargainingApplyServiceImpl.class);
    @Autowired
    private IUocBargainingModel uocBargainingModel;

    @PostMapping(value={"dealBargainingApply"})
    public UocResolveBargainingApplyRspBo dealBargainingApply(@RequestBody UocResolveBargainingApplyReqBo reqBo) {
        if (UocConstant.CREATED_RESULT.SUCCESS.equals(reqBo.getCreatedResult())) {
            UocBargainingQuotationDo uocBargainingQuotationDo = new UocBargainingQuotationDo();
            uocBargainingQuotationDo.setBargainingId(reqBo.getBargainingId());
            uocBargainingQuotationDo.setQuotationId(reqBo.getQuotationId());
            uocBargainingQuotationDo.setQuotationStatus("0");
            uocBargainingQuotationDo.setBiddingCode(reqBo.getBiddingCode());
            this.uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
            this.insertProgressRecord(reqBo, "\u6210\u529f\uff01");
        } else {
            UocBargainingDo uocBargainingDo = new UocBargainingDo();
            uocBargainingDo.setBargainingId(reqBo.getBargainingId());
            UocBargainingDo uocBargainingQryDo = this.uocBargainingModel.qryBargainingBy(uocBargainingDo);
            if ("YJ_BJZ".equals(uocBargainingQryDo.getBargainingState())) {
                if (uocBargainingQryDo.getQuoteCurrentRound() == 1) {
                    UocBargainingDo bargainingDo = new UocBargainingDo();
                    bargainingDo.setUpdateTime(new Date());
                    bargainingDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
                    bargainingDo.setUpdateOperName(reqBo.getName());
                    bargainingDo.setCancelTime(new Date());
                    bargainingDo.setCancelReason(reqBo.getCancelReason());
                    bargainingDo.setCancelOperName(reqBo.getName());
                    bargainingDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
                    bargainingDo.setBargainingState("YJ_SB");
                    bargainingDo.setBargainingId(reqBo.getBargainingId());
                    this.uocBargainingModel.updateBargaining(bargainingDo);
                }
                UocBargainingQuotationDo uocBargainingQuotationDo = new UocBargainingQuotationDo();
                uocBargainingQuotationDo.setBargainingId(reqBo.getBargainingId());
                uocBargainingQuotationDo.setQuotationId(reqBo.getQuotationId());
                uocBargainingQuotationDo.setQuotationStatus("3");
                uocBargainingQuotationDo.setQuotationReason(reqBo.getCancelReason());
                this.uocBargainingModel.updateQuotation(uocBargainingQuotationDo);
                reqBo.setCancelReason("\u7b2c" + uocBargainingQryDo.getQuoteCurrentRound() + "\u8f6e\u8bae\u4ef7\u53d1\u8d77\u5931\u8d25!");
                this.insertProgressRecord(reqBo, "\u5931\u8d25\uff01");
            } else {
                throw new BaseBusinessException("100001", "\u8bae\u4ef7\u7684\u72b6\u6001\u975e\u62a5\u4ef7\u4e2d\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\uff01");
            }
        }
        return UocRu.success(UocResolveBargainingApplyRspBo.class);
    }

    private void insertProgressRecord(UocResolveBargainingApplyReqBo reqBO, String resultDesc) {
        UocBargainingProgressRecordDo recordDo = new UocBargainingProgressRecordDo();
        recordDo.setProgressRecordId(IdUtil.nextId());
        recordDo.setBargainingId(reqBO.getBargainingId());
        recordDo.setOperType(UocConstant.BARGAINING_OPER_TYPE.CREATE);
        recordDo.setOperTypeName("\u8bae\u4ef7\u5355\u63d0\u4ea4");
        recordDo.setOperId((long)reqBO.getUserId());
        recordDo.setOperName(reqBO.getName());
        recordDo.setOperTime(new Date());
        recordDo.setRemark("\u63d0\u4ea4\u7ed3\u679c\uff1a" + resultDesc);
        this.uocBargainingModel.insertProgressRecord(recordDo);
    }
}

