/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderCreateTransaction;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderCreateService"})
public class UocAfterOrderCreateServiceImpl
implements UocAfterOrderCreateService {
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocAfterOrderCreateTransaction uocAfterOrderCreateTransaction;

    @PostMapping(value={"createAfterOrder"})
    public UocAfterOrderCreateRspBo createAfterOrder(@RequestBody UocAfterOrderCreateReqBo reqBo) {
        UocAfterOrderCreateRspBo rspBo = this.uocAfterOrderCreateTransaction.createAfterOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocAfterOrderCreateReqBo reqBo, UocAfterOrderCreateRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncSaleEsRunnableBo.setObjId(reqBo.getSaleOrderId());
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncShipEsRunnableBo.setObjId(reqBo.getShipOrderId());
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncShipEsRunnableBo);
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncAfEsRunnableBo.setObjId(rspBo.getAfOrderId());
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncAfEsRunnableBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

