/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocAuditOrderCancelService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditOrderCancelServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditOrderCancelServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocAuditOrderCancelServiceTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAuditOrderCancelService"})
public class UocAuditOrderCancelServiceImpl
implements UocAuditOrderCancelService {
    private static final Logger log = LoggerFactory.getLogger(UocAuditOrderCancelServiceImpl.class);
    @Autowired
    private UocAuditOrderCancelServiceTransaction uocAuditOrderCancelServiceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"cancelAuditOrder"})
    public UocAuditOrderCancelServiceRspBo cancelAuditOrder(@RequestBody UocAuditOrderCancelServiceReqBo reqBo) {
        UocAuditOrderCancelServiceRspBo rspBo = this.uocAuditOrderCancelServiceTransaction.cancelAuditOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocAuditOrderCancelServiceReqBo reqBo, UocAuditOrderCancelServiceRspBo rspBo) {
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(this.uocIndexConfig.getApprovalOrderPlusIndex());
        orderBo.setOrderId(rspBo.getOrderId());
        orderBo.setObjId(rspBo.getAuditOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(orderBo));
    }
}

