/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocReceiveItInspOrderNoItemService;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemRspBo;
import com.tydic.dyc.oc.transactionservice.UocArrvaITAcceptanceByNoItemTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocReceiveItInspOrderNoItemService"})
public class UocReceiveItInspOrderNoItemServiceImpl
implements UocReceiveItInspOrderNoItemService {
    private static final Logger log = LoggerFactory.getLogger(UocReceiveItInspOrderNoItemServiceImpl.class);
    @Autowired
    private UocArrvaITAcceptanceByNoItemTransaction uocArrvaITAcceptanceByNoItemTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealReceiveItInspOrderNoItem"})
    public UocReceiveItInspOrderNoItemRspBo dealReceiveItInspOrderNoItem(@RequestBody UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocReceiveItInspOrderNoItemRspBo rspBo = this.uocArrvaITAcceptanceByNoItemTransaction.dealItArrvalAcceptance(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocReceiveItInspOrderNoItemReqBo reqBo, UocReceiveItInspOrderNoItemRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        list.add(inspBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

