/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfInspection;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.UocQryInspectionConfigService;
import com.tydic.dyc.oc.service.order.bo.UocInspectionConfigQryAbilityCommodityBo;
import com.tydic.dyc.oc.service.order.bo.UocQryInspectionConfigReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryInspectionConfigRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.order.UocQryInspectionConfigService"})
public class UocQryInspectionConfigServiceImpl
implements UocQryInspectionConfigService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"qryInspectionConfig"})
    public UocQryInspectionConfigRspBo qryInspectionConfig(@RequestBody UocQryInspectionConfigReqBo reqBo) {
        UocConfInspection uocConfInspection = UocRu.js(reqBo, UocConfInspection.class);
        List<UocConfInspection> uocConfInspections = this.iUocOrderModel.qryInspectionConfigList(uocConfInspection);
        UocQryInspectionConfigRspBo rspBo = UocRu.success(UocQryInspectionConfigRspBo.class);
        if (!CollectionUtils.isEmpty(uocConfInspections)) {
            ArrayList<String> pCodeList = new ArrayList<String>();
            pCodeList.add("INSPECTION_BUSI_TYPE");
            pCodeList.add("INSPECTION_TYPE");
            if (UocConstant.INSPECTION_TYPE_ALL.equals(reqBo.getInspectionType())) {
                rspBo.setAllExcessPercent(uocConfInspections.get(0).getExcessPercent());
            } else {
                List<UocInspectionConfigQryAbilityCommodityBo> commodityDatas = UocRu.jsl(uocConfInspections, UocInspectionConfigQryAbilityCommodityBo.class);
                rspBo.setCommodityDatas(commodityDatas);
            }
            rspBo.setInspectionType(reqBo.getInspectionType());
            rspBo.setBusiType(reqBo.getBusiType());
            DictFrameworkUtils.translateByAnnotation((Object)rspBo);
        }
        return rspBo;
    }
}

