/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocDealAgrOrderFinishService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAgrOrderFinishReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAgrOrderFinishRspBO;
import com.tydic.dyc.oc.transactionservice.UocDealAgrOrderFinishTransaction;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealAgrOrderFinishService"})
public class UocDealAgrOrderFinishServiceImpl
implements UocDealAgrOrderFinishService {
    @Autowired
    private UocDealAgrOrderFinishTransaction uocDealAgrOrderFinishTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealAgrOrderFinish"})
    public UocDealAgrOrderFinishRspBO dealAgrOrderFinish(@RequestBody UocDealAgrOrderFinishReqBO reqBO) {
        UocDealAgrOrderFinishRspBO rspBo = this.uocDealAgrOrderFinishTransaction.dealAgrOrderFinish(reqBO);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealAgrOrderFinishReqBO reqBO, UocDealAgrOrderFinishRspBO rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        orderBo.setOrderId(reqBO.getOrderId());
        orderBo.setObjId(reqBO.getSaleOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

