/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService"})
public class UocSaleOrderRefuseServiceImpl
implements UocSaleOrderRefuseService {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderRefuseServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Value(value="${uoc.UocSaleOrderRefuseServiceImpl.dealSaleOrderRefuse:true}")
    private boolean dealSaleOrderRefuse;
    @Value(value="${uoc.UocSaleOrderRefuseServiceImpl.refuseOrderDesc:\u8be5\u8ba2\u5355\u5df2\u8fdb\u884c\u9a8c\u6536\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u62d2\u6536\u64cd\u4f5c}")
    private String refuseOrderDesc;

    @PostMapping(value={"dealSaleOrderRefuse"})
    public UocSaleOrderRefuseRspBo dealSaleOrderRefuse(@RequestBody UocSaleOrderRefuseReqBo reqBo) {
        this.verifyParam(reqBo);
        UocSaleOrderRefuseRspBo rspBo = new UocSaleOrderRefuseRspBo();
        if (this.dealSaleOrderRefuse) {
            UocInspOrderQryBo qryInspBo = new UocInspOrderQryBo();
            qryInspBo.setSaleOrderId(reqBo.getSaleOrderId());
            qryInspBo.setOrderId(reqBo.getOrderId());
            log.info("\u8ba2\u5355\u62d2\u6536\uff0c\u67e5\u8be2\u9a8c\u6536\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)qryInspBo)));
            List<UocInspOrderDo> listInspOrder = this.iUocInspOrderModel.getListInspOrder(qryInspBo);
            log.info("\u8ba2\u5355\u62d2\u6536\uff0c\u67e5\u8be2\u9a8c\u6536\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString(listInspOrder));
            if (ObjectUtil.isNotEmpty(listInspOrder)) {
                rspBo.setRespCode("103005");
                rspBo.setRespDesc(this.refuseOrderDesc);
                return rspBo;
            }
        }
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateUocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateUocSaleOrderDo.setRejectOperId(String.valueOf(reqBo.getUserId()));
        updateUocSaleOrderDo.setRejectOperName(reqBo.getName());
        updateUocSaleOrderDo.setRejectTime(new Date());
        updateUocSaleOrderDo.setRejectReason(reqBo.getRefuseReason());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            this.saveAccessoryInfo(reqBo);
        }
        this.commitTask(reqBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void saveAccessoryInfo(UocSaleOrderRefuseReqBo reqBo) {
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBo.getOrderAccessoryBoList()) {
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            BeanUtils.copyProperties((Object)uocBaseOrderAccessoryAddBo, (Object)uocOrderAccessory);
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setOrderId(reqBo.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.SALE_ORDER_REJECT);
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }

    private void commitTask(UocSaleOrderRefuseReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void verifyParam(UocSaleOrderRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5f53\u524d\u767b\u5f55\u4ebaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getName())) {
            throw new BaseBusinessException("100001", "\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getConfirmResult()) {
            throw new BaseBusinessException("100001", "\u786e\u8ba4\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

