/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderModifyStateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderModifyStateServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocChngOrderModifyStateTransaction {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocChngOrderModifyStateServiceRspBo modifyState(UocChngOrderModifyStateServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocChngOrderModifyStateServiceRspBo rspBo = UocRu.success(UocChngOrderModifyStateServiceRspBo.class);
        ArrayList<UocChngOrderDo> uocChngOrderDoList = new ArrayList<UocChngOrderDo>();
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        uocChngOrderDo.setChngOrderState(reqBo.getChngOrderState());
        uocChngOrderDoList.add(uocChngOrderDo);
        this.iUocChngOrderModel.modifyBatchChngOrderState(uocChngOrderDoList);
        return rspBo;
    }

    private void validateArg(UocChngOrderModifyStateServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException("100001", "\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getChngOrderState()) {
            throw new BaseBusinessException("100001", "\u53d8\u66f4\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

