/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.venus.extension.Extension;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ext.oc.service.UocSplitOrderServiceExtPt;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceItemBo;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceReqBo;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceRspBo;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceSaleOrderBo;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import com.tydic.dyc.oc.config.UocSystemConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqArgPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqPayConfBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocCreateOrderServiceTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocCreateOrderServiceTransaction.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;
    @Autowired
    private UocSystemConfig uocSystemConfig;
    @Value(value="${uoc.rpcSplitSwitch:false}")
    private boolean rpcSplitSwitch;
    @Extension
    @Autowired
    private UocSplitOrderServiceExtPt uocSplitOrderServiceExtPt;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocCreateOrderServiceRspBo createOrder(UocCreateOrderServiceReqBo reqBo) {
        log.info("\u8ba2\u5355\u521b\u5efa\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        UocOrderDo createOrderDo = (UocOrderDo)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocOrderDo.class));
        createOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createOrderDo.setCreateOperName(reqBo.getName());
        createOrderDo.setCreateTime(new Date());
        createOrderDo.setUsername(reqBo.getUserName());
        UocOrderDo orderResult = this.iUocOrderModel.createOrder(createOrderDo);
        log.info("\u4e0b\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)orderResult)));
        List saleOrderItemList = JSONArray.parseArray((String)JSON.toJSONString(orderResult.getOrderItems())).toJavaList(UocSaleOrderItem.class);
        this.createSplitKey(saleOrderItemList, reqBo.getSupplierBos());
        List<UocSaleOrderDo> createSaleOrderList = this.splitSaleOrderNew(reqBo, orderResult, saleOrderItemList);
        ArrayList<UocCreateOrderServiceRspSaleOrderBo> saleOrderResultList = new ArrayList<UocCreateOrderServiceRspSaleOrderBo>();
        for (UocSaleOrderDo saleOrderDo : createSaleOrderList) {
            saleOrderDo.setSaleOrderName(createOrderDo.getOrderName());
            UocSaleOrderDo saleOrder = this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
            UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
            BeanUtils.copyProperties((Object)((Object)saleOrder), (Object)orderItemRspData);
            BeanUtils.copyProperties((Object)saleOrder.getStakeholder(), (Object)orderItemRspData);
            orderItemRspData.setSaleOrderId(saleOrder.getSaleOrderId());
            List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrder.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
            orderItemRspData.setItemBoList(itemList);
            orderItemRspData.setSaleOrderNo(saleOrder.getSaleOrderNo());
            orderItemRspData.setOrderSource(saleOrder.getOrderSource());
            orderItemRspData.setAgrId(saleOrder.getAgreementId());
            orderItemRspData.setModelSettle(saleOrder.getModelSettle());
            orderItemRspData.setPayType(saleOrder.getPayType() != null ? Integer.valueOf(saleOrder.getPayType()) : null);
            saleOrderResultList.add(orderItemRspData);
        }
        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);
        rspBo.setTotalSaleFee(orderResult.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(orderResult.getTotalPurchaseFee());
        rspBo.setOrderId(orderResult.getOrderId());
        rspBo.setOrderNo(orderResult.getOrderNo());
        rspBo.setSaleOrderList(saleOrderResultList);
        return rspBo;
    }

    private void createSplitKey(List<UocSaleOrderItem> saleOrderItemList, List<UocSupplierInfoBo> supplierBos) {
        Map<Long, UocSupplierInfoBo> supplierInfoMap = supplierBos.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocSupplierInfoBo supplierInfoBo = supplierInfoMap.get(Long.valueOf(saleOrderItem.getSupplierId()));
            if (null == supplierInfoBo) {
                throw new BaseBusinessException("100100", "\u4f9b\u5e94\u5546\u652f\u4ed8\u914d\u7f6e\u96c6\u5408\u6ca1\u6709\u5305\u542b\u5b8c\u6240\u6709\u7684\u5546\u54c1\uff01");
            }
            String supplierIdModelSettelKey = "";
            supplierIdModelSettelKey = ObjectUtil.isNotEmpty((Object)supplierInfoBo.getExtPayConfigBos()) && supplierInfoBo.getExtSkuCategoryIds().contains(saleOrderItem.getCommodityTypeId()) ? saleOrderItem.getSupplierId() + "_" + ((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getExtPayConfigBos().get(0)).getModelSettle() : saleOrderItem.getSupplierId() + "_" + ((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getPayConfigBos().get(0)).getModelSettle();
            saleOrderItem.setSupplierIdModelSettelKey(supplierIdModelSettelKey);
        }
    }

    private List<UocSaleOrderDo> splitSaleOrderNew(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderInfo, List<UocSaleOrderItem> saleOrderItemList) {
        ArrayList<UocSaleOrderDo> saleOrderList = new ArrayList<UocSaleOrderDo>();
        List<UocSaleOrderDo> splitSaleOrderResultList = this.splitOrder(saleOrderItemList, orderInfo);
        List supplierInfoList = reqBo.getSupplierBos();
        Map<Object, Object> supplierInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)supplierInfoList)) {
            supplierInfoMap = supplierInfoList.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        }
        List agrPayConfigList = reqBo.getAgrPayConfigList();
        Map<Object, Object> agrPayConfigMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)agrPayConfigList)) {
            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
        }
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(orderInfo.getOrderId());
        List<UocOrderStakeholderQryBo> orderStakeholderList = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        Map<String, List<UocOrderStakeholderQryBo>> orderStakeholderMap = orderStakeholderList.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        Map<String, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSkuId, o -> o));
        for (UocSaleOrderDo saleOrderDo : splitSaleOrderResultList) {
            UocSaleOrderDo createSaleOrderDo = (UocSaleOrderDo)((Object)JUtil.js((Object)((Object)orderInfo), UocSaleOrderDo.class));
            saleOrderList.add(createSaleOrderDo);
            createSaleOrderDo.setExtFields(saleOrderDo.getExtFields());
            if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getExtFields())) {
                createSaleOrderDo.setSaleOrderMapList(JUtil.jsl((List)saleOrderDo.getExtFields(), UocSaleOrderMap.class));
            }
            List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
            for (UocSaleOrderItem each : saleOrderItems) {
                List extFields = each.getExtFields();
                BeanUtils.copyProperties((Object)((Object)saleOrderItemMap.get(each.getSkuId())), (Object)((Object)each));
                if (!ObjectUtil.isNotEmpty((Object)extFields)) continue;
                ArrayList<UocSaleItemMap> itemMapList = new ArrayList<UocSaleItemMap>();
                for (BaseExtendFieldBo extField : extFields) {
                    UocSaleItemMap uocSaleItemMap = new UocSaleItemMap();
                    uocSaleItemMap.setId(IdUtil.nextId());
                    uocSaleItemMap.setOrderId(createSaleOrderDo.getOrderId());
                    uocSaleItemMap.setCreateTime(createSaleOrderDo.getCreateTime());
                    uocSaleItemMap.setCreateOperId(createSaleOrderDo.getCreateOperId());
                    uocSaleItemMap.setFieldCode(extField.getFieldCode());
                    uocSaleItemMap.setFieldName(extField.getFieldName());
                    uocSaleItemMap.setFieldValue(extField.getFieldValue());
                    uocSaleItemMap.setRemark(extField.getRemark());
                    itemMapList.add(uocSaleItemMap);
                }
                each.setSaleItemMapList(itemMapList);
            }
            createSaleOrderDo.setSaleOrderItems(saleOrderItems);
            createSaleOrderDo.setSaleOrderAccessoryList(orderInfo.getAccessoryList());
            createSaleOrderDo.setOrderSource(saleOrderItems.get(0).getSkuSource());
            createSaleOrderDo.setStakeholderId(orderStakeholderMap.get(saleOrderItems.get(0).getSupplierId()).get(0).getStakeholderId());
            createSaleOrderDo.setStakeholder(UocRu.js(orderStakeholderMap.get(saleOrderItems.get(0).getSupplierId()).get(0), UocSaleStakeholder.class));
            createSaleOrderDo.setTotalSaleFee(this.computeSaleOrderTotalSaleFee(saleOrderItems, saleOrderItemMap));
            createSaleOrderDo.setTotalPurchaseFee(this.computeSaleOrderTotalPurchaseFee(saleOrderItems, saleOrderItemMap));
            createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.SUCCESS);
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderItems.get(0).getSkuSource())) {
                createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.PROCESSING);
            }
            if ("1".equals(((UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(saleOrderItems.get(0).getSupplierId()))).getMonthReceiveNode())) {
                createSaleOrderDo.setIsCreateServiceFee(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)saleOrderItems.get(0).getAgreementId())) {
                List payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId())).getConfBos())).toJavaList(UocSaleOrderPayConf.class);
                List agrList = orderInfo.getOrderItems().stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getAgreementId())).map(UocOrderItem::getAgrBo).collect(Collectors.toList());
                Map agrMap = agrList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, Function.identity(), (oldValue, newValue) -> newValue));
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    BigDecimal totalFee = UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType()) ? createSaleOrderDo.getTotalSaleFee() : createSaleOrderDo.getTotalPurchaseFee();
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        payConf.setPrePayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                            payConf.setPrePayFee(totalFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                            payConf.setVerPayFee(totalFee.multiply(payConf.getVerPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                            payConf.setPilPayFee(totalFee.multiply(payConf.getPilPaySup()));
                        }
                        if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                        payConf.setQuaPayFee(totalFee.multiply(payConf.getQuaPaySup()));
                        continue;
                    }
                    if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                        if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                            payConf.setVerPayFee(totalFee);
                            continue;
                        }
                        if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) continue;
                        payConf.setPilPayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                        payConf.setVerPayFee(totalFee);
                        continue;
                    }
                    if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) continue;
                    payConf.setPilPayFee(totalFee);
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
                createSaleOrderDo.setModelSettle(UocConstant.ModelSettle.CH);
                createSaleOrderDo.setAgreementId(saleOrderItems.get(0).getAgreementId());
                createSaleOrderDo.setAgreementNo(saleOrderItems.get(0).getAgreementNo());
                createSaleOrderDo.setAgrDataId(((UocOrderAgreement)((Object)agrMap.get(saleOrderItems.get(0).getAgreementId()))).getId());
                createSaleOrderDo.setProDeliveryId(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId())).getProDeliveryId());
                createSaleOrderDo.setProDeliveryName(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId())).getProDeliveryName());
            } else {
                List payConfigBos;
                UocSupplierInfoBo supplierInfoBo = (UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(saleOrderItems.get(0).getSupplierId()));
                if (ObjectUtil.isNotEmpty((Object)supplierInfoBo.getExtSkuCategoryIds()) && supplierInfoBo.getExtSkuCategoryIds().contains(saleOrderItems.get(0).getCommodityTypeId())) {
                    payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)supplierInfoBo.getExtPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                    createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getExtPayConfigBos().get(0)).getModelSettle());
                } else {
                    payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)supplierInfoBo.getPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                    createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)supplierInfoBo.getPayConfigBos().get(0)).getModelSettle());
                }
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    BigDecimal totalFee = UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType()) ? createSaleOrderDo.getTotalSaleFee() : createSaleOrderDo.getTotalPurchaseFee();
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        payConf.setPrePayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                            payConf.setPrePayFee(totalFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                            payConf.setVerPayFee(totalFee.multiply(payConf.getVerPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                            payConf.setPilPayFee(totalFee.multiply(payConf.getPilPaySup()));
                        }
                        if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                        payConf.setQuaPayFee(totalFee.multiply(payConf.getQuaPaySup()));
                        continue;
                    }
                    if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                        if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                            payConf.setVerPayFee(totalFee);
                            continue;
                        }
                        if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) continue;
                        payConf.setPilPayFee(totalFee);
                        continue;
                    }
                    if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                        payConf.setVerPayFee(totalFee);
                        continue;
                    }
                    if (!UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) continue;
                    payConf.setPilPayFee(totalFee);
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
            }
            this.deliveryCycle(createSaleOrderDo);
        }
        return saleOrderList;
    }

    private List<UocSaleOrderDo> splitOrder(List<UocSaleOrderItem> saleOrderItemList, UocOrderDo orderInfo) {
        ArrayList<UocSaleOrderDo> saleOrderDoList = new ArrayList<UocSaleOrderDo>();
        if (!this.rpcSplitSwitch) {
            Map<Integer, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
            for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleOrderItemMap.entrySet()) {
                UocOrderSourceProcessor instance = this.uocOrderSourceProcessorManager.getInstance(entry.getKey());
                for (List<UocSaleOrderItem> uocSaleOrderItems : instance.splitSaleOrder(entry.getValue())) {
                    UocSaleOrderDo createSaleOrderDo = new UocSaleOrderDo();
                    createSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
                    saleOrderDoList.add(createSaleOrderDo);
                }
            }
        } else {
            UocSplitOrderServiceReqBo rpcSplitOrderReqBo = new UocSplitOrderServiceReqBo();
            rpcSplitOrderReqBo.setItemList(JUtil.jsl(saleOrderItemList, UocSplitOrderServiceItemBo.class));
            rpcSplitOrderReqBo.setExtFields(orderInfo.getExtFields());
            log.info("\u8c03\u7528rpc\u62c6\u5355\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rpcSplitOrderReqBo));
            UocSplitOrderServiceRspBo rpcSplitOrderBo = this.uocSplitOrderServiceExtPt.splitOrder(rpcSplitOrderReqBo);
            log.info("\u8c03\u7528rpc\u62c6\u5355\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rpcSplitOrderBo));
            this.validateSplitRsp(rpcSplitOrderBo);
            if (null != rpcSplitOrderBo) {
                if ("0000".equals(rpcSplitOrderBo.getRespCode())) {
                    List splitOrderList = rpcSplitOrderBo.getSplitSaleOrderList();
                    for (UocSplitOrderServiceSaleOrderBo uocSplitOrderServiceSaleOrderBo : splitOrderList) {
                        UocSaleOrderDo uocSaleOrderDo = (UocSaleOrderDo)((Object)JUtil.js((Object)uocSplitOrderServiceSaleOrderBo, UocSaleOrderDo.class));
                        uocSaleOrderDo.setSaleOrderItems(JUtil.jsl((List)uocSplitOrderServiceSaleOrderBo.getSplitItemList(), UocSaleOrderItem.class));
                        saleOrderDoList.add(uocSaleOrderDo);
                    }
                } else {
                    throw new BaseBusinessException("104001", "\u8c03\u7528rpc\u670d\u52a1\u62c6\u5355\u5931\u8d25\uff1a" + rpcSplitOrderBo.getRespDesc());
                }
            }
        }
        return saleOrderDoList;
    }

    private static UocSplitOrderServiceRspBo mockTest() {
        UocSplitOrderServiceRspBo rpcSplitOrderBo = (UocSplitOrderServiceRspBo)JSON.parseObject((String)"{\n  \"code\": \"0\",\n  \"eventList\": [],\n  \"extFields\": [],\n  \"message\": \"\u6210\u529f\",\n  \"respCode\": \"0000\",\n  \"respDesc\": \"\u6210\u529f\",\n  \"splitSaleOrderList\": [\n    {\n      \"agreementId\": \"1147132682782646272\",\n      \"agreementNo\": \"\",\n      \"extFields\": [\n        {\n          \"fieldCode\": \"itAgrOrderCode\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"1\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"itAgrOrderFlag\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u662f\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"relevantDeptName\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u4ea4\u884c\uff08\u4e2a\u6027\u5316\uff09\u8fd0\u8425\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"relevantDeptCode\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u6269\u5c55\u5b57\u6bb56\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"relevantDeptId\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"1134138067028807680\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"jhAgrDepartment\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u4ea4\u884c\uff08\u4e2a\u6027\u5316\uff09\u8fd0\u8425\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"jhAgrDepartmentId\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"1134138067028807680\",\n          \"remark\": \"\"\n        }\n      ],\n      \"orderSource\": 3,\n      \"orderSourceStr\": \"\",\n      \"splitItemList\": [\n        {\n          \"agrBo\": {\n            \"adjustPrice\": 0,\n            \"agreementCode\": 2,\n            \"agreementId\": \"1147132682782646272\",\n            \"extFields\": [\n              {\n                \"fieldCode\": \"itAgrOrderCode\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"1\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"itAgrOrderFlag\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u662f\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"agrMainExtendJson\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"{}\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"relevantDeptName\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u4ea4\u884c\uff08\u4e2a\u6027\u5316\uff09\u8fd0\u8425\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"relevantDeptCode\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u6269\u5c55\u5b57\u6bb56\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"agrMainExtend3\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"IT\u5408\u540c\u7c7b\u578b\u540d\u79f0001\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"relevantDeptId\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"1134138067028807680\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"jhAgrDepartment\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u4ea4\u884c\uff08\u4e2a\u6027\u5316\uff09\u8fd0\u8425\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"agrMainExtend7\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"1697444058180702208\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"jhAgrDepartmentId\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"1134138067028807680\",\n                \"remark\": \"\"\n              }\n            ],\n            \"producerId\": 33,\n            \"scopeType\": 3,\n            \"supplierId\": 1137033162682032128,\n            \"tradeMode\": 2,\n            \"vendorId\": 1137033162682032128\n          },\n          \"agreementId\": \"1147132682782646272\",\n          \"agreementIdItemNo\": \"\",\n          \"agreementNo\": \"\",\n          \"commodityCode\": \"\",\n          \"commodityId\": \"99229212\",\n          \"commodityTypeId\": \"10010101\",\n          \"extFields\": [\n            {\n              \"fieldCode\": \"purchasePurposeId\",\n              \"fieldName\": \"\u91c7\u8d2d\u7528\u9014(\u5546\u54c1\u660e\u7ec6)\",\n              \"fieldValue\": \"893501119366529025\",\n              \"remark\": \"\"\n            },\n            {\n              \"fieldCode\": \"purchasePurposeName\",\n              \"fieldName\": \"\u91c7\u8d2d\u7528\u9014(\u5546\u54c1\u660e\u7ec6)\",\n              \"fieldValue\": \"\u91c7\u8d2d\u7528\u90140828\",\n              \"remark\": \"\"\n            }\n          ],\n          \"orderId\": 1149359463282855936,\n          \"orderItemId\": 1149359463282855977,\n          \"orderPlanBOList\": [],\n          \"planId\": \"\",\n          \"planItemId\": \"\",\n          \"purchaseCount\": 1.00,\n          \"skuCode\": \"6000000188348001\",\n          \"skuId\": \"100163884\",\n          \"skuMaterialTypeId\": \"null\",\n          \"skuName\": \"\u5546\u54c1\u540d\u79f01 \u5c5e\u6027\u503c1\",\n          \"skuSource\": 3,\n          \"supplierId\": \"1137033162682032128\",\n          \"supplierShopId\": \"1134138067028807680\"\n        }\n      ],\n      \"supId\": \"1137033162682032128\"\n    },\n    {\n      \"agreementId\": \"1146023963311218688\",\n      \"agreementNo\": \"\",\n      \"extFields\": [\n        {\n          \"fieldCode\": \"itAgrOrderCode\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"0\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"itAgrOrderFlag\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u5426\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"relevantDeptName\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u4ea4\u884c\uff08\u4e2a\u6027\u5316\uff09\u8fd0\u8425\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"relevantDeptCode\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u6269\u5c55\u5b57\u6bb56\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"relevantDeptId\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"1134138067028807680\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"jhAgrDepartment\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"\u4ea4\u884c\u5206\u884c\u91c7\u8d2dC\u90e8\u95e81\",\n          \"remark\": \"\"\n        },\n        {\n          \"fieldCode\": \"jhAgrDepartmentId\",\n          \"fieldName\": \"\",\n          \"fieldValue\": \"1136694738318024704\",\n          \"remark\": \"\"\n        }\n      ],\n      \"orderSource\": 3,\n      \"orderSourceStr\": \"\",\n      \"splitItemList\": [\n        {\n          \"agrBo\": {\n            \"adjustPrice\": 0,\n            \"agreementCode\": 2,\n            \"agreementId\": \"1146023963311218688\",\n            \"extFields\": [\n              {\n                \"fieldCode\": \"itAgrOrderCode\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"0\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"itAgrOrderFlag\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u5426\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"agrMainExtendJson\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"{}\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"relevantDeptName\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u4ea4\u884c\uff08\u4e2a\u6027\u5316\uff09\u8fd0\u8425\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"relevantDeptCode\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u6269\u5c55\u5b57\u6bb56\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"agrMainExtend3\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"IT\u5408\u540c\u7c7b\u578b\u540d\u79f0-0816\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"relevantDeptId\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"1134138067028807680\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"jhAgrDepartment\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"\u4ea4\u884c\u5206\u884c\u91c7\u8d2dC\u90e8\u95e81\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"agrMainExtend7\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"IT\u5408\u540c\u7c7b\u578bid\",\n                \"remark\": \"\"\n              },\n              {\n                \"fieldCode\": \"jhAgrDepartmentId\",\n                \"fieldName\": \"\",\n                \"fieldValue\": \"1136694738318024704\",\n                \"remark\": \"\"\n              }\n            ],\n            \"producerId\": 33,\n            \"scopeType\": 3,\n            \"supplierId\": 1137033162682032128,\n            \"tradeMode\": 2,\n            \"vendorId\": 1137033162682032128\n          },\n          \"agreementId\": \"1146023963311218688\",\n          \"agreementIdItemNo\": \"\",\n          \"agreementNo\": \"\",\n          \"commodityCode\": \"\",\n          \"commodityId\": \"99229159\",\n          \"commodityTypeId\": \"10010101\",\n          \"extFields\": [\n            {\n              \"fieldCode\": \"purchasePurposeId\",\n              \"fieldName\": \"\u91c7\u8d2d\u7528\u9014(\u5546\u54c1\u660e\u7ec6)\",\n              \"fieldValue\": \"893501119366529025\",\n              \"remark\": \"\"\n            },\n            {\n              \"fieldCode\": \"purchasePurposeName\",\n              \"fieldName\": \"\u91c7\u8d2d\u7528\u9014(\u5546\u54c1\u660e\u7ec6)\",\n              \"fieldValue\": \"\u91c7\u8d2d\u7528\u90140828\",\n              \"remark\": \"\"\n            }\n          ],\n          \"orderId\": 1149359463282855936,\n          \"orderItemId\": 1149359463282855953,\n          \"orderPlanBOList\": [],\n          \"planId\": \"\",\n          \"planItemId\": \"\",\n          \"purchaseCount\": 1.00,\n          \"skuCode\": \"6000000188102002\",\n          \"skuId\": \"100163817\",\n          \"skuMaterialTypeId\": \"null\",\n          \"skuName\": \"\u4e07\u5b9d\u9f99\u9ccd\u578b\u94a2\u7b14\u5b9a\u5236 \u6d4b\u8bd5\u534f\u8bae\u8ba2\u5355\u7528\uff08\u52ff\u52a8\uff09 \u5c5e\u6027\u503c2\",\n          \"skuSource\": 3,\n          \"supplierId\": \"1137033162682032128\",\n          \"supplierShopId\": \"1134138067028807680\"\n        }\n      ],\n      \"supId\": \"1137033162682032128\"\n    }\n  ]\n}", UocSplitOrderServiceRspBo.class);
        return rpcSplitOrderBo;
    }

    private void validateSplitRsp(UocSplitOrderServiceRspBo rpcSplitOrderBo) {
        List extFieldList;
        if (ObjectUtil.isEmpty((Object)rpcSplitOrderBo)) {
            throw new BaseBusinessException("104001", "\u8c03\u7528rpc\u670d\u52a1\u62c6\u5355\u5931\u8d25\uff1a\u8fd4\u56de\u51fa\u53c2\u4e3a\u7a7a");
        }
        List splitSaleOrderList = rpcSplitOrderBo.getSplitSaleOrderList();
        for (UocSplitOrderServiceSaleOrderBo uocSplitOrderServiceSaleOrderBo : splitSaleOrderList) {
            extFieldList = uocSplitOrderServiceSaleOrderBo.getExtFields();
            LinkedHashMap<String, BaseExtendFieldBo> map = new LinkedHashMap<String, BaseExtendFieldBo>();
            for (BaseExtendFieldBo obj : extFieldList) {
                String key = obj.getFieldCode() + "_" + obj.getFieldValue();
                if (map.containsKey(key)) continue;
                map.put(key, obj);
            }
            uocSplitOrderServiceSaleOrderBo.setExtFields(new ArrayList(map.values()));
            List splitItemList = uocSplitOrderServiceSaleOrderBo.getSplitItemList();
            for (UocSplitOrderServiceItemBo uocSplitOrderServiceItemBo : splitItemList) {
                LinkedHashMap<String, BaseExtendFieldBo> saleItemMap = new LinkedHashMap<String, BaseExtendFieldBo>();
                for (BaseExtendFieldBo obj : uocSplitOrderServiceItemBo.getExtFields()) {
                    String key = obj.getFieldCode() + "_" + obj.getFieldValue();
                    if (saleItemMap.containsKey(key)) continue;
                    saleItemMap.put(key, obj);
                }
                uocSplitOrderServiceItemBo.setExtFields(new ArrayList(saleItemMap.values()));
            }
        }
        log.info("\u8c03\u7528rpc\u62c6\u5355\u670d\u52a1\u51fa\u53c2(\u8fc7\u6ee4\u76f8\u540ckey\u76f8\u540cvalue\u4e4b\u540e)\uff1a{}", (Object)JSON.toJSONString((Object)rpcSplitOrderBo));
        for (UocSplitOrderServiceSaleOrderBo uocSplitOrderServiceSaleOrderBo : splitSaleOrderList) {
            extFieldList = uocSplitOrderServiceSaleOrderBo.getExtFields();
            Set set = extFieldList.stream().map(BaseExtendFieldBo::getFieldCode).collect(Collectors.toSet());
            if (extFieldList.size() <= set.size()) continue;
            throw new BaseBusinessException("104001", "\u8c03\u7528rpc\u670d\u52a1\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u9500\u552e\u5355\u7ef4\u5ea6\u6269\u5c55\u5b57\u6bb5\u91cd\u590d");
        }
    }

    private BigDecimal computeSaleOrderTotalPurchaseFee(List<UocSaleOrderItem> orderItem, Map<String, UocSaleOrderItem> saleOrderItemMap) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal computeSaleOrderTotalSaleFee(List<UocSaleOrderItem> orderItem, Map<String, UocSaleOrderItem> saleOrderItemMap) {
        BigDecimal totalSaleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            totalSaleFee = totalSaleFee.add(uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getSalePrice()));
        }
        return totalSaleFee;
    }

    private UocSaleOrderDo deliveryCycle(UocSaleOrderDo createSaleOrderDo) {
        if (createSaleOrderDo.getOrderSource().equals(UocConstant.SkuSource.AGR)) {
            List<UocSaleOrderItem> uocSaleOrderItems = createSaleOrderDo.getSaleOrderItems();
            uocSaleOrderItems.forEach(obj -> {
                if (StringUtils.isNotEmpty((CharSequence)obj.getDeliveryTimeDate())) {
                    ArrayList<UocSaleItemMap> saleItemMapList = new ArrayList<UocSaleItemMap>();
                    UocSaleItemMap uocSaleItemMap = new UocSaleItemMap();
                    uocSaleItemMap.setFieldCode("delivery_cycle");
                    uocSaleItemMap.setFieldName("\u4f9b\u8d27\u5468\u671f");
                    uocSaleItemMap.setFieldValue(obj.getDeliveryTimeDate());
                    saleItemMapList.add(uocSaleItemMap);
                    obj.setSaleItemMapList(saleItemMapList);
                }
            });
            createSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
        }
        return createSaleOrderDo;
    }
}

