package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.base.core.dictionary.bo.DictDataBo;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocEsSyncChng
 * 说明:变更单
 * 时间:2022/3/10 14:52
 * 作者:罗有
 */

@Slf4j
@Service
public class UocEsSyncChng implements IUocEsSync {

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;


    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;


    private static final String LINE = "_";

    @Override
    public String indexName() {
        return uocIndexConfig.getChngOrderIndex();
    }

//    @Override
//    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
//        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
//        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
//        UocChngOrderDo chngOrder = getUocChngOrderDo(reqBo);
//        if (null == chngOrder) {
//            return iUocEsSyncQryRspBo;
//        }
////        Map<String, Map<String, String>> dicMap = getDic();
//        List<UocChngOrderObj> chngOrderObjList = getChngOrderObjList(reqBo);
//        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
//        UocInspOrderDo inspOrderDo = new UocInspOrderDo();
//        List<String> shipOrderNoList = new ArrayList<>();
//        Long inspOrderId = null;
//        String inspOrderNo = "";
//        Integer addOrSubtractType = null;
//        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
//            chngOrder.setChngType(chngOrderObjList.get(0).getChngType());
//            if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE)) && ObjectUtil.isNotNull(chngOrderObjList.get(0).getChngType())) {
//                chngOrder.setChngTypeStr(dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE).get(chngOrderObjList.get(0).getChngType().toString()));
//            }
//            // 迪易采
//            List<UocChngOrderObj> filterChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull(each.getChngType()) && each.getChngType().equals(4)).collect(Collectors.toList());
//            if (ObjectUtil.isNotEmpty(filterChngOrderObjs)) {
//                uocShipOrderDo = getUocShipOrderDo(filterChngOrderObjs);
//                if (ObjectUtil.isNotNull(uocShipOrderDo)) {
//                    shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
//                    //chngOrder.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
//                    chngOrder.setShipOrderState(uocShipOrderDo.getShipOrderState());
//                    chngOrder.setInspTime(uocShipOrderDo.getInspTime());
//                    chngOrder.setInspOperName(uocShipOrderDo.getInspOperName());
//                    if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.ShipOrder.P_CODE))) {
//                        chngOrder.setShipOrderStateStr(dicMap.get(UocStateConstants.ShipOrder.P_CODE).get(uocShipOrderDo.getShipOrderState()));
//                    }
//                    chngOrder.setObjOrderState(chngOrder.getShipOrderState());
//                    chngOrder.setObjOrderStateStr(chngOrder.getShipOrderStateStr());
//                    //查询发货单明细
//                    uocShipOrderDo.setShipOrderItemBoList(getShipOrderItem(uocShipOrderDo).getShipOrderItemBoList());
//                }
//            }
//
//            //华润
//            List<UocChngOrderObj> filterInspChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull(each.getInspOrderId())).collect(Collectors.toList());
//            if (ObjectUtil.isNotEmpty(filterInspChngOrderObjs)) {
//                inspOrderDo = getInspOrderDo(filterInspChngOrderObjs);
//                if (ObjectUtil.isNotEmpty(inspOrderDo)) {
//                    inspOrderId = inspOrderDo.getInspOrderId();
//                    inspOrderNo = inspOrderDo.getInspOrderNo();
//                    chngOrder.setInspTime(inspOrderDo.getCreateTime());
//                    chngOrder.setInspOperName(inspOrderDo.getInspOper());
//                    chngOrder.setInspSaleFee(inspOrderDo.getTotalSaleFee());
//                    List<UocShipOrderDo> uocShipOrderDoList = getListShipOrder(inspOrderDo);
//                    if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
//                        uocShipOrderDoList.forEach(shipOrderDo -> {
//                            shipOrderNoList.add(shipOrderDo.getShipOrderNo());
//                        });
//                    }
//                    chngOrder.setInspOrderState(inspOrderDo.getInspOrderState());
//                    if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.InspOrder.P_CODE))) {
//                        chngOrder.setInspOrderStateStr(dicMap.get(UocStateConstants.InspOrder.P_CODE).get(inspOrderDo.getInspOrderState()));
//                    }
//                    chngOrder.setObjOrderState(chngOrder.getInspOrderState());
//                    chngOrder.setObjOrderStateStr(chngOrder.getInspOrderStateStr());
//                    //查询验收单明细getInspOrderItem
//                    inspOrderDo.setUocInspOrderItemList(getInspOrderItem(inspOrderDo).getUocInspOrderItemList());
//                }
//            }
//
//            // 数量变更
//            if (chngOrder.getChngType() == 1){
//                //数量变更退款、付款
//                List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
//                chngOrderObjList.forEach(x->{
//                    if ( !CollectionUtils.isEmpty(x.getUocChngOrderItemObjList()) ) {
//                        uocChngOrderItemObjList.addAll(x.getUocChngOrderItemObjList());
//                    }
//                    x.setChngFee(x.getChngFee().abs());
//                });
//                BigDecimal chngFee = BigDecimal.ZERO;
//                for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
//                    if (uocChngOrderItemObj.getAddOrSubtractType() != null && uocChngOrderItemObj.getAddOrSubtractType() == 1){
//                        chngFee = chngFee.subtract(uocChngOrderItemObj.getChngFee());
//                    } else if (uocChngOrderItemObj.getAddOrSubtractType() != null && uocChngOrderItemObj.getAddOrSubtractType() == 2){
//                        chngFee = chngFee.add(uocChngOrderItemObj.getChngFee());
//                    }
//                }
//                addOrSubtractType = chngFee.compareTo(BigDecimal.ZERO) >= 0 ? 2 : 1;
//            }
//
//            // 状态变更
//            else if (chngOrder.getChngType() == 4){
//                BigDecimal chngFee = BigDecimal.ZERO;
//                for (UocChngOrderObj each : chngOrderObjList) {
//                    if (each.getChngFee() != null) {
//                        chngFee = chngFee.add(each.getChngFee());
//                    }
//                }
//                log.info("chngFee----------------:" + chngFee);
//                addOrSubtractType = chngFee.compareTo(BigDecimal.ZERO) >= 0 ? 2 : 1;
//            }
//
//        }
//
//
//        chngOrder.setUocChngOrderObjList(chngOrderObjList);
//        Map<String, String> chngOrderState = new HashMap<>();
//        if (ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
//            chngOrderState = dicMap.get(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
//        } else {
//            chngOrderState = dicMap.get(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
//        }
//        log.info("dicMap:{}", JSON.toJSONString(dicMap));
//        log.info(JSON.toJSONString(chngOrder));
//        chngOrder.setChngOrderStateStr(chngOrderState.get(chngOrder.getChngOrderState()));
//        JSONObject chngOrderJson = JSON.parseObject(JSON.toJSONString(chngOrder, SerializerFeature.WriteMapNullValue));
//        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO,shipOrderNoList);
//        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_NO,inspOrderNo);
//        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ID,inspOrderId);
//        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADD_OR_SUBTRACT_TYPE,addOrSubtractType);
//        if ( ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL) ) {
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, true);
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_CHNG_ORDER_ID, chngOrder.getChngOrderId());
//        } else {
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, false);
//        }
//        Map<Integer, UocChngOrderObj> chngTypeMaps = chngOrderObjList.stream().filter(obj->obj.getChngType() !=1 ).collect(Collectors.toMap(UocChngOrderObj::getChngType, o -> o));
//        UocChngOrderObj uocChngOrderObj2 = chngTypeMaps.get(2);
//        UocChngOrderObj uocChngOrderObj5 = chngTypeMaps.get(5);
//        Optional.ofNullable(uocChngOrderObj2).ifPresent(x -> chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADJUST_PURCHASE_PRICE, uocChngOrderObj2.getChngFee()));
//        Optional.ofNullable(uocChngOrderObj5).ifPresent(x -> chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADJUST_SALE_PRICE, uocChngOrderObj5.getChngFee()));
//        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
//            UocSaleOrderDo saleOrder = getSaleOrder(chngOrderObjList.get(0));
//            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
//            UocGetSaleOrderDetailServiceRspPorcBo chngBusiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
//            UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
//            if (null != saleOrder) {
//                Map<String, String> saleOrderStateDic = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
//                Map<String, String> payType = dicMap.get(UocDicConstant.PAY_TYPE.P_CODE);
//                Map<String, String> jdCzDicMaps = dicMap.get(UocDicConstant.VENDOR_ORD_TYPE.P_CODE);
//
////                saleOrder.setSaleOrderStateStr(saleOrderStateDic.get(saleOrder.getSaleOrderState()));
//
//                String saleOrderState = saleOrder.getSaleOrderState();
//                Integer orderSource = saleOrder.getOrderSource();
//
//
//
//                Optional.ofNullable(saleOrder.getPayType()).ifPresent(x -> saleOrder.setPayTypeStr(payType.get(x)));
//                saleOrder.setJdCzStr(jdCzDicMaps.get(String.valueOf(saleOrder.getJdCz().intValue())));
//                //采购模式翻译
//                if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.PURCHASE_MODE.P_CODE)) && ObjectUtil.isNotEmpty(saleOrder.getPurchaseMode())) {
//                    Integer purchaseMode = saleOrder.getPurchaseMode();
//                    saleOrder.setPurchaseModeStr(dicMap.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(String.valueOf(purchaseMode.intValue())));
//                }
//
////                Optional.ofNullable(saleOrder.getJdCz()).ifPresent(x -> saleOrder.setJdCzStr(jdCzDicMaps.get(x)));
////                saleOrder.setPayTypeStr(saleOrderState.get(saleOrder.getSaleOrderState()));
//                saleOrder.setModelSettleStr(null != saleOrder.getModelSettle() ?
//                        dicMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(saleOrder.getModelSettle() != null ? saleOrder.getModelSettle().toString() : saleOrder.getModelSettle()) : "");
//                List<UocSaleOrderItem> uocSaleOrderItemList = getListSaleOrderItem(chngOrderObjList.get(0));
//                if (ObjectUtil.isNotEmpty(uocSaleOrderItemList) && ObjectUtil.isNotEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
//                    Map<Long, UocSaleOrderItem> saleItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
//                    final BigDecimal[] saleFee = {BigDecimal.ZERO};
//                    final BigDecimal[] purFee = {BigDecimal.ZERO};
//                    uocShipOrderDo.getShipOrderItemBoList().forEach(each -> {
//                        if (saleItemMap.containsKey(each.getSaleOrderItemId()) && each.getSendCount() != null) {
//                            saleFee[0] = saleFee[0].add(saleItemMap.get(each.getSaleOrderItemId()).getSalePrice().multiply(each.getSendCount()));
//                            purFee[0] = purFee[0].add(saleItemMap.get(each.getSaleOrderItemId()).getPurchasePrice().multiply(each.getSendCount()));
//                        }
//                    });
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, saleFee[0]);
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, purFee[0]);
//                }
//
//                saleOrder.setSaleOrderItems(uocSaleOrderItemList);
//                List<UocSaleOrderPayConf> saleOrderPayConfList = getUocSaleOrderPayConf(saleOrder);
//                if (!CollectionUtils.isEmpty(saleOrderPayConfList)) {
//                    saleOrder.setSaleOrderPayConfList(saleOrderPayConfList);
//                    for (UocSaleOrderPayConf uocSaleOrderPayConf : saleOrderPayConfList) {
//                        if (UocDicConstant.USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType()) && null != uocSaleOrderPayConf.getPayType()) {
//                            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, payType.get(uocSaleOrderPayConf.getPayType().toString()));
//                        }
//                    }
//                }
//                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_SOURCE, saleOrder.getOrderSource());
//                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_SOURCE_STR, saleOrder.getOrderSourceStr());
//                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(saleOrder.getSaleOrderItems())));
//                if (ObjectUtil.isNotEmpty(saleOrder.getStakeholder())) {
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ID, saleOrder.getStakeholder().getSupId());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrder.getStakeholder().getSupName());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrder.getStakeholder().getPurOrgId());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, saleOrder.getStakeholder().getPurOrgName());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ID, saleOrder.getStakeholder().getProId());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, saleOrder.getStakeholder().getPurUserId());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_PATH, saleOrder.getStakeholder().getPurOrgPath());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ORG_PATH, saleOrder.getStakeholder().getSupOrgPath());
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ORG_PATH, saleOrder.getStakeholder().getProOrgPath());
//                }
//                //查询业务流程实例
//                busiProcInst = getProcInst(saleOrder.getOrderId(),saleOrder.getSaleOrderId(),UocDicConstant.OBJ_TYPE.SALE, false);
//
//                //订单状态翻译赋值保持和销售单一致
//                setSaleOrderStateStr(dicMap, saleOrder, busiProcInst, saleOrderState, orderSource);
//
//                //查询变更单业务流程实例
//                chngBusiProcInst = getProcInst(reqBo.getOrderId(),reqBo.getObjId(),UocDicConstant.OBJ_TYPE.CHNG, false);
//                //查询审批流程实例
//                auditProcInst = getProcInst(reqBo.getOrderId(),saleOrder.getSaleOrderId(),UocDicConstant.OBJ_TYPE.SALE, true);
//                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrder);
//                if (ObjectUtil.isNotEmpty(auditProcInst)){
//                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PROC_INST_ID,auditProcInst.getProcInstId());
//                }
//                //协议信息
//                //拉横协议信息
//                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrder.getOrderSource())) {
//                    //查询协议信息
//                    List<UocOrderAgreement> agreementOrderList = getAgreementOrderList(saleOrder);
//                    //协议信息
//                    if (ObjectUtil.isNotEmpty(agreementOrderList)) {
//                        putAgreementInfo(agreementOrderList, chngOrderJson);
//                    }
//                }
//
//                IUocEsSyncQryReqBo iUocEsSyncQryReqBo = new IUocEsSyncQryReqBo();
//                iUocEsSyncQryReqBo.setOrderId(saleOrder.getOrderId());
//                iUocEsSyncQryReqBo.setObjId(saleOrder.getSaleOrderId());
//
//                UocGetSaleOrderDetailServiceRspPorcBo auditProcInstBo;
//                if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrder.getOrderSource())) {
//                    auditProcInstBo = getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.ORDER);
//                } else {
//                    auditProcInstBo = getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.SALE);
//                }
//                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInstBo.getProcInstId());
//
//                //判断贸易模式 合并单据 明细信息
//                if (UocDicConstant.TRADE_MODE.TRADE_MODE.equals(saleOrder.getModelSettle())) {
//                    List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
//                    chngOrderObjList.forEach(x->{
//                        if ( !CollectionUtils.isEmpty(x.getUocChngOrderItemObjList()) ) {
//                            uocChngOrderItemObjList.addAll(x.getUocChngOrderItemObjList());
//                        }
//                    });
//                    chngOrderObjList = chngOrderObjList.stream().sorted(new Comparator<UocChngOrderObj>() {
//                        @Override
//                        public int compare(UocChngOrderObj o1, UocChngOrderObj o2) {
//                            return o1.getChngType().compareTo(o2.getChngType());
//                        }
//                    }).collect(Collectors.toList());
//                    Map<Long, List<UocChngOrderItemObj>> saleItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getSaleOrderItemId));
//                    for (UocChngOrderObj uocChngOrderObj : chngOrderObjList) {
//                        if (UocConstant.BUSI_TYPE.PRICE_CHG.equals(uocChngOrderObj.getChngType())) {
//                            List<UocChngOrderItemObj> chngOrderItemObjList = new ArrayList<>();
//                            List<UocChngOrderItemObj> uocChngOrderItemObjList1 = uocChngOrderObj.getUocChngOrderItemObjList();
//                            for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList1) {
//                                List<UocChngOrderItemObj> uocChngOrderItemObjs = saleItemMaps.get(uocChngOrderItemObj.getSaleOrderItemId());
//                                List<UocChngOrderItemObj> uocChngOrderItemObjsFive = uocChngOrderItemObjs.stream().filter(x -> UocConstant.BUSI_TYPE.STATE_FIVE.equals(x.getChngType())).collect(Collectors.toList());
//                                if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsFive)) {
//                                    uocChngOrderItemObj.setChngFeeFive(uocChngOrderItemObjsFive.get(0).getChngFee());
//                                }
//                                chngOrderItemObjList.add(uocChngOrderItemObj);
//                            }
//                            List<UocChngOrderObj> uocChngOrderObjs = new ArrayList<>();
//                            uocChngOrderObj.setUocChngOrderItemObjList(chngOrderItemObjList);
//                            uocChngOrderObjs.add(uocChngOrderObj);
//                            chngOrder.setUocChngOrderObjList(uocChngOrderObjs);
//                            break;
//                        }
//                    }
//                }
//            }
//            //查询销售单扩展
//            List<UocSaleOrderMap> saleOrderMapList = getSaleOrderMapList(chngOrderObjList.get(0));
//            JSONObject saleOrderObj = JSON.parseObject(JSON.toJSONString(saleOrder));
//            if (null != saleOrderMapList) {
//                saleOrderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), each.getFieldValue()));
//            }
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrderObj);
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, ObjectUtil.isNotEmpty(busiProcInst.getProcInstId()) ? busiProcInst.getProcInstId() : "");
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, ObjectUtil.isNotEmpty(busiProcInst.getTaskList()) ? busiProcInst.getTaskList() : new ArrayList<>());
//
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CHNG_BUSI_PROC_INST, ObjectUtil.isNotEmpty(chngBusiProcInst.getProcInstId()) ? chngBusiProcInst.getProcInstId() : "");
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CHNG_BUSI_TASK_INST, ObjectUtil.isNotEmpty(chngBusiProcInst.getTaskList()) ? chngBusiProcInst.getTaskList() : new ArrayList<>());
//            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, ObjectUtil.isNotEmpty(auditProcInst.getTaskList()) ? auditProcInst.getTaskList() : new ArrayList<>());
//        }
//        if (!CollectionUtils.isEmpty(chngOrder.getUocChngOrderMapList())) {
//            chngOrder.getUocChngOrderMapList().forEach(uocChngOrderMap -> chngOrderJson.put(uocChngOrderMap.getFieldCode(), uocChngOrderMap.getFieldValue()));
//        }
//
//        //查询收货人信息
//        chngOrderJson.put("contactShipName",getLogistics(chngOrder));
//
//        iUocEsSyncQryRspBo.setJsonObj(chngOrderJson);
//        return iUocEsSyncQryRspBo;
//    }

    /**
     * @remark 字典翻译代码重构
     * @author 欧迅
     * @time 2025.1.17
     */
    //todo 待删
    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocChngOrderDo chngOrder = getUocChngOrderDo(reqBo);
        if (null == chngOrder) {
            return iUocEsSyncQryRspBo;
        }
//        Map<String, Map<String, String>> dicMap = getDic();
        List<UocChngOrderObj> chngOrderObjList = getChngOrderObjList(reqBo);
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        UocInspOrderDo inspOrderDo = new UocInspOrderDo();
        List<String> shipOrderNoList = new ArrayList<>();
        Long inspOrderId = null;
        String inspOrderNo = "";
        Integer addOrSubtractType = null;
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            chngOrder.setChngType(chngOrderObjList.get(0).getChngType());
            // 迪易采
            List<UocChngOrderObj> filterChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull(each.getChngType()) && each.getChngType().equals(4)).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(filterChngOrderObjs)) {
                uocShipOrderDo = getUocShipOrderDo(filterChngOrderObjs);
                if (ObjectUtil.isNotNull(uocShipOrderDo)) {
                    shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                    //chngOrder.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
                    chngOrder.setShipOrderState(uocShipOrderDo.getShipOrderState());
                    chngOrder.setInspTime(uocShipOrderDo.getInspTime());
                    chngOrder.setInspOperName(uocShipOrderDo.getInspOperName());
                    chngOrder.setObjOrderState(chngOrder.getShipOrderState());
                    chngOrder.setObjOrderStateStr(chngOrder.getShipOrderStateStr());
                    //查询发货单明细
                    uocShipOrderDo.setShipOrderItemBoList(getShipOrderItem(uocShipOrderDo).getShipOrderItemBoList());
                }
            }
            /**
             * 字典翻译
             */
            DictFrameworkUtils.translateByAnnotation(chngOrder);
            //华润
            List<UocChngOrderObj> filterInspChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull(each.getInspOrderId())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(filterInspChngOrderObjs)) {
                inspOrderDo = getInspOrderDo(filterInspChngOrderObjs);
                if (ObjectUtil.isNotEmpty(inspOrderDo)) {
                    inspOrderId = inspOrderDo.getInspOrderId();
                    inspOrderNo = inspOrderDo.getInspOrderNo();
                    chngOrder.setInspTime(inspOrderDo.getCreateTime());
                    chngOrder.setInspOperName(inspOrderDo.getInspOper());
                    chngOrder.setInspSaleFee(inspOrderDo.getTotalSaleFee());
                    List<UocShipOrderDo> uocShipOrderDoList = getListShipOrder(inspOrderDo);
                    if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
                        uocShipOrderDoList.forEach(shipOrderDo -> {
                            shipOrderNoList.add(shipOrderDo.getShipOrderNo());
                        });
                    }
                    chngOrder.setInspOrderState(inspOrderDo.getInspOrderState());
                    /**
                     * 字典翻译
                     */
                    DictFrameworkUtils.translateByAnnotation(chngOrder);
                    chngOrder.setObjOrderState(chngOrder.getInspOrderState());
                    chngOrder.setObjOrderStateStr(chngOrder.getInspOrderStateStr());
                    //查询验收单明细getInspOrderItem
                    inspOrderDo.setUocInspOrderItemList(getInspOrderItem(inspOrderDo).getUocInspOrderItemList());
                }
            }

            // 数量变更
            if (chngOrder.getChngType() == 1){
                //数量变更退款、付款
                List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
                chngOrderObjList.forEach(x->{
                    if ( !CollectionUtils.isEmpty(x.getUocChngOrderItemObjList()) ) {
                        uocChngOrderItemObjList.addAll(x.getUocChngOrderItemObjList());
                    }
                    x.setChngFee(x.getChngFee().abs());
                });
                BigDecimal chngFee = BigDecimal.ZERO;
                for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
                    if (uocChngOrderItemObj.getAddOrSubtractType() != null && uocChngOrderItemObj.getAddOrSubtractType() == 1){
                        chngFee = chngFee.subtract(uocChngOrderItemObj.getChngFee());
                    } else if (uocChngOrderItemObj.getAddOrSubtractType() != null && uocChngOrderItemObj.getAddOrSubtractType() == 2){
                        chngFee = chngFee.add(uocChngOrderItemObj.getChngFee());
                    }
                }
                addOrSubtractType = chngFee.compareTo(BigDecimal.ZERO) >= 0 ? 2 : 1;
            }

            // 状态变更
            else if (chngOrder.getChngType() == 4){
                BigDecimal chngFee = BigDecimal.ZERO;
                for (UocChngOrderObj each : chngOrderObjList) {
                    if (each.getChngFee() != null) {
                        chngFee = chngFee.add(each.getChngFee());
                    }
                }
                log.info("chngFee----------------:" + chngFee);
                addOrSubtractType = chngFee.compareTo(BigDecimal.ZERO) >= 0 ? 2 : 1;
            }

        }


        chngOrder.setUocChngOrderObjList(chngOrderObjList);
        /**
         * 字典翻译
         */
        if (ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
            chngOrder.setChngOrderStateStr(DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE,chngOrder.getChngOrderState())==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE,chngOrder.getChngOrderState()).getValue());
        } else {
            chngOrder.setChngOrderStateStr(DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE,chngOrder.getChngOrderState())==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE,chngOrder.getChngOrderState()).getValue());
        }
        log.info(JSON.toJSONString(chngOrder));
        JSONObject chngOrderJson = JSON.parseObject(JSON.toJSONString(chngOrder, SerializerFeature.WriteMapNullValue));
        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO,shipOrderNoList);
        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_NO,inspOrderNo);
        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ID,inspOrderId);
        chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADD_OR_SUBTRACT_TYPE,addOrSubtractType);
        if ( ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL) ) {
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, true);
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_CHNG_ORDER_ID, chngOrder.getChngOrderId());
        } else {
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, false);
        }
        Map<Integer, UocChngOrderObj> chngTypeMaps = chngOrderObjList.stream().filter(obj->obj.getChngType() !=1 ).collect(Collectors.toMap(UocChngOrderObj::getChngType, o -> o));
        UocChngOrderObj uocChngOrderObj2 = chngTypeMaps.get(2);
        UocChngOrderObj uocChngOrderObj5 = chngTypeMaps.get(5);
        Optional.ofNullable(uocChngOrderObj2).ifPresent(x -> chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADJUST_PURCHASE_PRICE, uocChngOrderObj2.getChngFee()));
        Optional.ofNullable(uocChngOrderObj5).ifPresent(x -> chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ADJUST_SALE_PRICE, uocChngOrderObj5.getChngFee()));
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            UocSaleOrderDo saleOrder = getSaleOrder(chngOrderObjList.get(0));
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            UocGetSaleOrderDetailServiceRspPorcBo chngBusiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            if (null != saleOrder) {
//                Map<String, String> saleOrderStateDic = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
//                Map<String, String> payType = dicMap.get(UocDicConstant.PAY_TYPE.P_CODE);
//                Map<String, String> jdCzDicMaps = dicMap.get(UocDicConstant.VENDOR_ORD_TYPE.P_CODE);

//                saleOrder.setSaleOrderStateStr(saleOrderStateDic.get(saleOrder.getSaleOrderState()));

                String saleOrderState = saleOrder.getSaleOrderState();
                Integer orderSource = saleOrder.getOrderSource();

                /**
                 * 字典翻译
                 */
                DictFrameworkUtils.translateByAnnotation(saleOrder);
//                Optional.ofNullable(saleOrder.getJdCz()).ifPresent(x -> saleOrder.setJdCzStr(jdCzDicMaps.get(x)));
//                saleOrder.setPayTypeStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                if (null == saleOrder.getModelSettleStr()){
                    saleOrder.setModelSettleStr("");
                }
                List<UocSaleOrderItem> uocSaleOrderItemList = getListSaleOrderItem(chngOrderObjList.get(0));
                if (ObjectUtil.isNotEmpty(uocSaleOrderItemList) && ObjectUtil.isNotEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                    Map<Long, UocSaleOrderItem> saleItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
                    final BigDecimal[] saleFee = {BigDecimal.ZERO};
                    final BigDecimal[] purFee = {BigDecimal.ZERO};
                    uocShipOrderDo.getShipOrderItemBoList().forEach(each -> {
                        if (saleItemMap.containsKey(each.getSaleOrderItemId()) && each.getSendCount() != null) {
                            saleFee[0] = saleFee[0].add(saleItemMap.get(each.getSaleOrderItemId()).getSalePrice().multiply(each.getSendCount()));
                            purFee[0] = purFee[0].add(saleItemMap.get(each.getSaleOrderItemId()).getPurchasePrice().multiply(each.getSendCount()));
                        }
                    });
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, saleFee[0]);
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, purFee[0]);
                }

                saleOrder.setSaleOrderItems(uocSaleOrderItemList);
                List<UocSaleOrderPayConf> saleOrderPayConfList = getUocSaleOrderPayConf(saleOrder);
                if (!CollectionUtils.isEmpty(saleOrderPayConfList)) {
                    saleOrder.setSaleOrderPayConfList(saleOrderPayConfList);
                    for (UocSaleOrderPayConf uocSaleOrderPayConf : saleOrderPayConfList) {
                        if (UocDicConstant.USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType()) && null != uocSaleOrderPayConf.getPayType()) {
                            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocDicConstant.PAY_TYPE.P_CODE,uocSaleOrderPayConf.getPayType().toString())==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocDicConstant.PAY_TYPE.P_CODE,uocSaleOrderPayConf.getPayType().toString()).getValue());
                        }
                    }
                }
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_SOURCE, saleOrder.getOrderSource());
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.ORDER_SOURCE_STR, saleOrder.getOrderSourceStr());
                chngOrderJson.put("itemType", saleOrder.getSaleOrderItems().get(0).getItemType());
                chngOrderJson.put("itemTypeStr", DictFrameworkUtils.getDictDataByCode("UOC_PRO", UocDicConstant.ITEM_TYPE.P_CODE, saleOrder.getSaleOrderItems().get(0).getItemType().toString()).getValue());
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(saleOrder.getSaleOrderItems())));
                if (ObjectUtil.isNotEmpty(saleOrder.getStakeholder())) {
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ID, saleOrder.getStakeholder().getSupId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrder.getStakeholder().getSupName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrder.getStakeholder().getPurOrgId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, saleOrder.getStakeholder().getPurOrgName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_ID, saleOrder.getStakeholder().getPurCompanyId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_COMPANY_NAME, saleOrder.getStakeholder().getPurCompanyName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ID, saleOrder.getStakeholder().getProId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, saleOrder.getStakeholder().getPurUserId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_PATH, saleOrder.getStakeholder().getPurOrgPath());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ORG_PATH, saleOrder.getStakeholder().getSupOrgPath());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ORG_PATH, saleOrder.getStakeholder().getProOrgPath());
                }
                //查询业务流程实例
                busiProcInst = getProcInst(saleOrder.getOrderId(),saleOrder.getSaleOrderId(),UocDicConstant.OBJ_TYPE.SALE, false);

                //订单状态翻译赋值保持和销售单一致
                setSaleOrderStateStr(saleOrder, busiProcInst, saleOrderState, orderSource);

                //查询变更单业务流程实例
                chngBusiProcInst = getProcInst(reqBo.getOrderId(),reqBo.getObjId(),UocDicConstant.OBJ_TYPE.CHNG, false);
                //查询审批流程实例
                auditProcInst = getProcInst(reqBo.getOrderId(),saleOrder.getSaleOrderId(),UocDicConstant.OBJ_TYPE.SALE, true);
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrder);
                if (ObjectUtil.isNotEmpty(auditProcInst)){
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PROC_INST_ID,auditProcInst.getProcInstId());
                }
                //协议信息
                //拉横协议信息
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrder.getOrderSource())) {
                    //查询协议信息
                    List<UocOrderAgreement> agreementOrderList = getAgreementOrderList(saleOrder);
                    //协议信息
                    if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                        putAgreementInfo(agreementOrderList, chngOrderJson);
                    }
                }

                IUocEsSyncQryReqBo iUocEsSyncQryReqBo = new IUocEsSyncQryReqBo();
                iUocEsSyncQryReqBo.setOrderId(saleOrder.getOrderId());
                iUocEsSyncQryReqBo.setObjId(saleOrder.getSaleOrderId());

                UocGetSaleOrderDetailServiceRspPorcBo auditProcInstBo;
                if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrder.getOrderSource())) {
                    auditProcInstBo = getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.ORDER);
                } else {
                    auditProcInstBo = getAuditProcInst(iUocEsSyncQryReqBo, UocDicConstant.OBJ_TYPE.SALE);
                }
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInstBo.getProcInstId());

                //判断贸易模式 合并单据 明细信息
                if (UocDicConstant.TRADE_MODE.TRADE_MODE.equals(saleOrder.getModelSettle())) {
                    List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
                    chngOrderObjList.forEach(x->{
                        if ( !CollectionUtils.isEmpty(x.getUocChngOrderItemObjList()) ) {
                            uocChngOrderItemObjList.addAll(x.getUocChngOrderItemObjList());
                        }
                    });
                    chngOrderObjList = chngOrderObjList.stream().sorted(new Comparator<UocChngOrderObj>() {
                        @Override
                        public int compare(UocChngOrderObj o1, UocChngOrderObj o2) {
                            return o1.getChngType().compareTo(o2.getChngType());
                        }
                    }).collect(Collectors.toList());
                    Map<Long, List<UocChngOrderItemObj>> saleItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getSaleOrderItemId));
                    for (UocChngOrderObj uocChngOrderObj : chngOrderObjList) {
                        if (UocConstant.BUSI_TYPE.PRICE_CHG.equals(uocChngOrderObj.getChngType())) {
                            List<UocChngOrderItemObj> chngOrderItemObjList = new ArrayList<>();
                            List<UocChngOrderItemObj> uocChngOrderItemObjList1 = uocChngOrderObj.getUocChngOrderItemObjList();
                            for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList1) {
                                List<UocChngOrderItemObj> uocChngOrderItemObjs = saleItemMaps.get(uocChngOrderItemObj.getSaleOrderItemId());
                                List<UocChngOrderItemObj> uocChngOrderItemObjsFive = uocChngOrderItemObjs.stream().filter(x -> UocConstant.BUSI_TYPE.STATE_FIVE.equals(x.getChngType())).collect(Collectors.toList());
                                if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsFive)) {
                                    uocChngOrderItemObj.setChngFeeFive(uocChngOrderItemObjsFive.get(0).getChngFee());
                                }
                                chngOrderItemObjList.add(uocChngOrderItemObj);
                            }
                            List<UocChngOrderObj> uocChngOrderObjs = new ArrayList<>();
                            uocChngOrderObj.setUocChngOrderItemObjList(chngOrderItemObjList);
                            uocChngOrderObjs.add(uocChngOrderObj);
                            chngOrder.setUocChngOrderObjList(uocChngOrderObjs);
                            break;
                        }
                    }
                }
            }
            //查询销售单扩展
            List<UocSaleOrderMap> saleOrderMapList = getSaleOrderMapList(chngOrderObjList.get(0));
            JSONObject saleOrderObj = JSON.parseObject(JSON.toJSONString(saleOrder));
            if (null != saleOrderMapList) {
                saleOrderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), each.getFieldValue()));
            }
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrderObj);
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, ObjectUtil.isNotEmpty(busiProcInst.getProcInstId()) ? busiProcInst.getProcInstId() : "");
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, ObjectUtil.isNotEmpty(busiProcInst.getTaskList()) ? busiProcInst.getTaskList() : new ArrayList<>());

            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CHNG_BUSI_PROC_INST, ObjectUtil.isNotEmpty(chngBusiProcInst.getProcInstId()) ? chngBusiProcInst.getProcInstId() : "");
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.CHNG_BUSI_TASK_INST, ObjectUtil.isNotEmpty(chngBusiProcInst.getTaskList()) ? chngBusiProcInst.getTaskList() : new ArrayList<>());
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, ObjectUtil.isNotEmpty(auditProcInst.getTaskList()) ? auditProcInst.getTaskList() : new ArrayList<>());
        }
        if (!CollectionUtils.isEmpty(chngOrder.getUocChngOrderMapList())) {
            chngOrder.getUocChngOrderMapList().forEach(uocChngOrderMap -> chngOrderJson.put(uocChngOrderMap.getFieldCode(), uocChngOrderMap.getFieldValue()));
        }

        //查询收货人信息
        chngOrderJson.put("contactShipName",getLogistics(chngOrder));

        iUocEsSyncQryRspBo.setJsonObj(chngOrderJson);
        return iUocEsSyncQryRspBo;
    }

//    private void setSaleOrderStateStr(Map<String, Map<String, String>> dicMap, UocSaleOrderDo saleOrder, UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, String saleOrderState, Integer orderSource) {
//        List<String> stateList = new ArrayList<>();
//        log.info("busiProcInst.getProcState:" + busiProcInst.getProcState());
//        log.info("saleOrderState:" + saleOrderState);
//        //new state：
//        stateList.add(saleOrderState);
//
////          old state
////        if (StringUtils.isNotBlank(saleOrderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
////            if (UocStateConstants.SaleOrder.XS_FH_FHWC.equals(saleOrderState) || UocStateConstants.SaleOrder.XS_FH_FHZ.equals(saleOrderState)) {
////                stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHZ);
////                stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHWC);
////            } else if (UocStateConstants.SaleOrder.XS_FH_DFH.equals(saleOrderState) && UocStateConstants.SaleTachCode.TC3_DFH.equals(busiProcInst.getProcState())) {
////                stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
////                stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
////                stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
////            } else {
////                stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
////            }
////        } else if (StringUtils.isNotBlank(saleOrderState)) {
////            stateList.add(saleOrderState);
////        } else if (StringUtils.isNotBlank(busiProcInst.getProcState())) {
////            if (UocStateConstants.SaleTachCode.TC1_DFH.equals(busiProcInst.getProcState())
////                    || UocStateConstants.SaleTachCode.TC2_DFH.equals(busiProcInst.getProcState())) {
////                stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
////                stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
////                stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
////            } else {
////                stateList.add(busiProcInst.getProcState());
////            }
////        }
//        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE)) && ObjectUtil.isNotEmpty(saleOrder.getSaleOrderState())) {
//            String saleOrdStateCode = saleOrder.getSaleOrderState();
//            log.debug("翻译销售单状态");
//            saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(saleOrdStateCode));
//            log.debug("翻译销售单状态" + saleOrder.getSaleOrderStateStr());
//        }
//        /*log.info("stateList:" + stateList);
//        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE)) && UocConstant.SkuSource.SELF.equals(orderSource)) {
//            if (ObjectUtil.isNotEmpty(stateList)) {
//                saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE).get(stateList.get(0)));
//            }
//        }
//        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM)) && UocConstant.SkuSource.ELC.equals(orderSource)) {
//            if (ObjectUtil.isNotEmpty(stateList)) {
//                saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM).get(stateList.get(0)));
//            }
//        }
//        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE)) && UocConstant.SkuSource.AGR.equals(orderSource)) {
//            if (ObjectUtil.isNotEmpty(stateList)) {
//                saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE).get(stateList.get(0)));
//            }
//        }*/
//    }

    /**
     * @remark 字典翻译代码重构
     * @author 欧迅
     * @time 2025.1.17
     */
    //todo 待删
    private void setSaleOrderStateStr(UocSaleOrderDo saleOrder, UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, String saleOrderState, Integer orderSource) {
        List<String> stateList = new ArrayList<>();
        log.info("busiProcInst.getProcState:" + busiProcInst.getProcState());
        log.info("saleOrderState:" + saleOrderState);
        //new state：
        stateList.add(saleOrderState);

//          old state
//        if (StringUtils.isNotBlank(saleOrderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
//            if (UocStateConstants.SaleOrder.XS_FH_FHWC.equals(saleOrderState) || UocStateConstants.SaleOrder.XS_FH_FHZ.equals(saleOrderState)) {
//                stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHZ);
//                stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHWC);
//            } else if (UocStateConstants.SaleOrder.XS_FH_DFH.equals(saleOrderState) && UocStateConstants.SaleTachCode.TC3_DFH.equals(busiProcInst.getProcState())) {
//                stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
//                stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
//                stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
//            } else {
//                stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
//            }
//        } else if (StringUtils.isNotBlank(saleOrderState)) {
//            stateList.add(saleOrderState);
//        } else if (StringUtils.isNotBlank(busiProcInst.getProcState())) {
//            if (UocStateConstants.SaleTachCode.TC1_DFH.equals(busiProcInst.getProcState())
//                    || UocStateConstants.SaleTachCode.TC2_DFH.equals(busiProcInst.getProcState())) {
//                stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
//                stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
//                stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
//            } else {
//                stateList.add(busiProcInst.getProcState());
//            }
//        }
        log.debug("翻译销售单状态");
        /**
         * 字典翻译
         */
        DictFrameworkUtils.translateByAnnotation(saleOrder);
        log.debug("翻译销售单状态" + saleOrder.getSaleOrderStateStr());
        /*log.info("stateList:" + stateList);
        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE)) && UocConstant.SkuSource.SELF.equals(orderSource)) {
            if (ObjectUtil.isNotEmpty(stateList)) {
                saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE).get(stateList.get(0)));
            }
        }
        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM)) && UocConstant.SkuSource.ELC.equals(orderSource)) {
            if (ObjectUtil.isNotEmpty(stateList)) {
                saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM).get(stateList.get(0)));
            }
        }
        if (ObjectUtil.isNotEmpty(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE)) && UocConstant.SkuSource.AGR.equals(orderSource)) {
            if (ObjectUtil.isNotEmpty(stateList)) {
                saleOrder.setSaleOrderStateStr(dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE).get(stateList.get(0)));
            }
        }*/
    }

    /**
     * 查询销售单扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap
     */
    private List<UocSaleOrderMap> getSaleOrderMapList(UocChngOrderObj reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        
        return iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }
    
    private UocInspOrderDo getInspOrderDo(List<UocChngOrderObj> filterChngOrderObjs) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(filterChngOrderObjs.get(0).getOrderId());
        uocInspOrderQryBo.setInspOrderId(filterChngOrderObjs.get(0).getInspOrderId());
        UocInspOrderDo inspOrderMain = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
        return inspOrderMain;

    }

    private UocChngOrderDo getUocChngOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setChngOrderId(reqBo.getObjId());
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
    }

    /**
     * 协议单列表查询
     *
     * @param saleOrder
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocOrderAgreement></>
     */
    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrder.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrder.getAgrDataId());
        return iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }
    /**
     * 收货人信息查询
     */
    private String getLogistics(UocChngOrderDo uocAfOrder) {
        UocOrdLogisticsRela logisticsRela = new UocOrdLogisticsRela();
        if (null != uocAfOrder) {
            UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setOrderId(uocAfOrder.getOrderId());
            UocOrderDo uocOrderDo = getUocOrderDo(uocAfOrder.getOrderId());
            relaQryBo.setContactId(uocOrderDo.getContactId());
            logisticsRela = iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        }
        return logisticsRela.getContactName();
    }
    /**
     * 查询订单主体
     */
    private UocOrderDo getUocOrderDo(Long orderId) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(orderId);
        return iUocOrderModel.qryOrderBy(qryBo);
    }

    /**
     * 拉横协议信息
     *
     * @param agreementOrderList
     * @param saleOrderObj
     */
    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        //协议模式
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE, agreement.getAgreementCode());
        //平台协议编号
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.PLA_AGR_CODE, agreement.getPlaAgreementCode());
        //协议名称
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_NAME, agreement.getAgreementName());
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_ID, agreement.getAgreementId());
    }

    private List<UocShipOrderDo> getListShipOrder(UocInspOrderDo uocInspOrderDo) {
        if (CollectionUtils.isEmpty(uocInspOrderDo.getUocShipInspRelList())) {
            return new ArrayList<>();
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderIdList(uocInspOrderDo.getUocShipInspRelList().stream().map(UocShipInspRel::getShipOrderId).collect(Collectors.toList()));
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private UocShipOrderDo getUocShipOrderDo(List<UocChngOrderObj> chngOrderObjList) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(chngOrderObjList.get(0).getOrderId());
        uocShipOrderQryBo.setShipOrderId(chngOrderObjList.get(0).getShipOrderId());
        UocShipOrderDo shipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        return shipOrderDo;
    }

    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }
    
    private UocInspOrderDo getInspOrderItem(UocInspOrderDo inspOrderDo) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderId(inspOrderDo.getInspOrderId());
        uocInspOrderItemQryBo.setOrderId(inspOrderDo.getOrderId());
        return iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
    }

    private List<UocChngOrderObj> getChngOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setChngOrderId(reqBo.getObjId());
        return iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

//    private Map<String, Map<String, String>> getDic() {
//        List<String> pCodes = new ArrayList<>();
//        pCodes.add(UocStateConstants.InspOrder.P_CODE);
//        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
//        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
//        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
//        pCodes.add(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
//        pCodes.add(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
//        pCodes.add(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE);
//        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
//        pCodes.add(UocDicConstant.VENDOR_ORD_TYPE.P_CODE);
//        pCodes.add(UocDicConstant.PURCHASE_MODE.P_CODE);
//        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE);
//        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE);
//        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM);
//        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
//    }

    private List<UocSaleOrderPayConf> getUocSaleOrderPayConf(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        return iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    /**
     * 查询流程任务实例
     *
     * @param orderId
     * @param objId
     * @param objType
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(Long orderId,Long objId,Integer objType, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(objId);
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(orderId);
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                /*taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });*/

                //为了联调，先取第一个环节编码和任务id
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param objType
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询销售单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        //销售单
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {//整单
            uocApprovalObjQryBo.setObjId(reqBo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }

        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            //taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    /*UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);*/
                    List<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<>();
                    UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
                    BeanUtils.copyProperties(each, uocOrderTaskDeal);
                    uocOrderTaskDeal.setDealId(each.getTaskUserId().toString());
                    uocOrderTaskDeal.setDealName(each.getTaskUserName());
                    uocOrderTaskDeals.add(uocOrderTaskDeal);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDea = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDea.getDealId();
                        String dealName = uocOrderTaskDea.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                procInst.setTaskList(taskBoList);

                String procInstId = "";
                if (UocDicConstant.OBJ_TYPE.ORDER.equals(objType)) {
                    procInstId = uocOrderTaskInsts.get(0).getProcInstId();
                } else {
                    //取审批未结束的审批实例Id
                    for (UocOrderTaskInst bo : uocOrderTaskInsts) {
                        if (0 == bo.getFinishTag()) {
                            procInstId = bo.getProcInstId();
                            break;
                        }
                    }
                }
                if (StringUtils.isNotBlank(procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }

        }
        return procInst;
    }
}
