package com.tydic.dyc.oc.components.ordSourceProcessor.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocOrderSourceProcessorNoAgr
 * 说明:协议处理类
 * 时间:2022/4/6 14:45
 * 作者:田桂银
 */
@Slf4j
@Component
public class UocOrderSourceProcessorAgr implements UocOrderSourceProcessor {

    @Override
    public List<List<UocSaleOrderItem>> splitSaleOrder(List<UocSaleOrderItem> reqSaleItemList) {
        List<List<UocSaleOrderItem>> retList = new ArrayList<>();
        //根据供应商拆单
        Map<String, List<UocSaleOrderItem>> supMap = reqSaleItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSupplierId));

        for (Map.Entry<String, List<UocSaleOrderItem>> entry : supMap.entrySet()) {
            //根据协议进行拆单
            Map<String, List<UocSaleOrderItem>> agrMap = entry.getValue().stream().collect(Collectors.groupingBy(UocSaleOrderItem::getAgreementId));
            for (Map.Entry<String, List<UocSaleOrderItem>> agrEntry : agrMap.entrySet()) {
                //根据计划id是否为空，分两波处理，非计划的一组，计划的再根据计划id拆一次单
                /*List<UocSaleOrderItem> noPlanList = agrEntry.getValue().stream().filter(item -> ObjectUtil.isEmpty(item.getPlanId())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(noPlanList)) {
                    retList.add(noPlanList);
                }*/
                /*List<UocSaleOrderItem> planList = agrEntry.getValue().stream().filter(item -> !ObjectUtil.isEmpty(item.getPlanId())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(planList)) {
                    retList.addAll(planList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getPlanId)).values());
                }*/
                List<UocSaleOrderItem> itemList = agrEntry.getValue().stream().filter(item -> !ObjectUtil.isEmpty(item.getItemType())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(itemList)) {
                    retList.addAll(itemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getItemType)).values());
                }
            }
        }
        log.debug("协议订单：" + JSON.toJSONString(retList));
        return retList;
    }

    @Override
    public Integer skuSource() {
        return UocDicConstant.ORDER_SOURCE.AGR_GENERATE;
    }
}


