package com.tydic.dyc.oc.components.thread;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.DycBaseLogConstant;
import com.tydic.dyc.oc.components.thread.runnable.LogTraceIdRunnable;
import org.slf4j.MDC;

import javax.validation.constraints.NotNull;
import java.util.concurrent.*;

/**
 * 标题:SaasThreadPoolExecutor
 * 说明:
 * 时间:2023/10/7 16:51
 * 作者:田桂银
 */
public class DycThreadPoolExecutor extends ThreadPoolExecutor {

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull ThreadFactory threadFactory, @NotNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        //包装成可以跟启动线程打印相同日志调用traceId的线程来运行
        super.execute(wrapWithLogTraceIdRunnable(command));
    }

    public static Runnable wrapWithLogTraceIdRunnable(Runnable runnable) {
        String logTraceId = MDC.get(DycBaseLogConstant.X_B3_TraceId);
        if (ObjectUtil.isNotEmpty(logTraceId)) {
            return new LogTraceIdRunnable(runnable, logTraceId);
        } else {
            return runnable;
        }
    }
}


