package com.tydic.dyc.oc.config;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * 标题:UocStateTacheCodeInitConfig
 * 说明:订单初始化配置
 * 时间:2022/3/3 15:43
 * 作者:田桂银
 */
@Slf4j
@Configuration
public class UocInitConfig {

    /**
     * 初始化状态配置
     */
    @Value("${uoc.init.initState:}")
    private String initState;

    private static final String SEPARATOR = "-";

    @Value("${virgo.service.code.order.state:UOC_GET_ORDER_STATUS}")
    private String serviceCode;

    /**
     * 描述:根据环节编码换取状态值，未配置返回空
     *
     * @param tacheCode 环节编码
     * @param objType   对象类型
     * @return java.lang.String
     * @author tgy
     * @date 2022/3/3 16:02
     */
    public String getStateByTachecode(String tacheCode, Integer objType) {
        if (ObjectUtil.isEmpty(tacheCode)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "环节编码不能为空");
        }
        if (ObjectUtil.isEmpty(objType)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "业务类型不能为空");
        }
        //return getState(tacheCode, objType);
        return getStateNew(tacheCode, objType);
//        Map<String, String> stateMap = new HashMap<>();
//        if (ObjectUtil.isNotEmpty(initState)) {
//            String[] configArray = initState.split(",");
//            for (String codeStr : configArray) {
//                String[] codeArray = codeStr.split(":");
//                if (codeArray.length != 2) {
//                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "环节状态配置有误，请检查");
//                }
//                String code = codeArray[0];
//                String state = codeArray[1];
//                if (ObjectUtil.isNotEmpty(stateMap.get(code))) {
//                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "环节状态配置有重复key，请检查");
//                }
//                stateMap.put(code, state);
//            }
//        }
//        return stateMap.get(objType + SEPARATOR + tacheCode);
    }

    private String getStateNew(String tacheCode, Integer objType) {
        String[] rules = initState.split(",");
        Map<String, String> stateMap = new HashMap<>();
        for (String ru : rules) {
            String[] rus = ru.split(":");
            stateMap.put(rus[0], rus[1]);
        }

        String key = objType+"-"+tacheCode;
        log.debug("stateMap:" + stateMap);
        log.debug("key" + key);
        System.out.println("key" + key);
        return stateMap.get(key);
    }

}


