package com.tydic.dyc.oc.model.bargaining.sub;

import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=false)
public class UocBargainingItem implements Serializable {
    /**
     * 议价单明细id
     */
    private Long bargainingItemId;
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 单品ID
     */
    private Long skuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 外部单品ID
     */
    private String extSkuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * 采购用途ID
     */
    private String purPurposeId;
    /**
     * 采购用途名称
     */
    private String purPurposeName;
    /**
     * 收支项目ID
     */
    private String paymentProjectId;
    /**
     * 收支项目名称
     */
    private String paymentProjectName;
    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;
    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;
    /**
     * 采购金额
     */
    private BigDecimal salePrice;
    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;
    /**
     * 销售金额
     */
    private BigDecimal saleFee;
    /**
     * 采购金额
     */
    private BigDecimal purchaseFee;
    /**
     * 期望单价 预留
     */
    private BigDecimal expectPrice;
    /**
     * 运费
     */
    private BigDecimal transFee;
    /**
     * 币种
     */
    private String currencyType;
    /**
     * 税金
     */
    private String taxPrice;
    /**
     * 税率
     */
    private String tax;
    /**
     * 计量单位
     */
    private String unitName;
    /**
     * 结算计量单位
     */
    private String settleUnit;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 更新工号
     */
    private String updateOperId;
    /**
     * 规格
     */
    private String spec;
    /**
     * 型号
     */
    private String model;
    /**
     * 材质
     */
    private String texture;
    /**
     * 图号
     */
    private String figure;
    /**
     * 备注
     */
    private String remark;
    /**
     * 扩展字段
     */
    private String extField1;
    /**
     * 扩展字段
     */
    private String extField2;
    /**
     * 扩展字段
     */
    private String extField3;
    /**
     * 扩展字段
     */
    private String extField4;
    /**
     * 扩展字段
     */
    private String extField5;
    /**
     * 扩展字段
     */
    private String extField6;
    /**
     * 扩展字段
     */
    private String extField7;
    /**
     * 扩展字段
     */
    private String extField10;
    /**
     * 扩展字段
     */
    private String extField8;
    /**
     * 扩展字段
     */
    private String extField9;
    /**
     * 创建时间（冗余运营检索用)
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 议价人ID（冗余运营检索用)
     */
    private String bargainingOperId;
    /**
     * 议价单编码（冗余运营检索用)
     */
    private String bargainingNo;
    /**
     * 供应商ID（冗余运营检索用)
     */
    private String supId;
    /**
     * 采购方公司id（冗余运营检索用)
     */
    private String purCompanyId;
    /**
     * 商品来源，区分电商、协议、无协议
	 */
    private Integer skuSource;
    /**
     * sku品牌id
     */
    private String skuBrandId;
    /**
     * sku品牌
     */
    private String skuBrandName;
    /**
     * 采购方机构id
     */
    private String purOrgId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 采购方机构名称
     */
    private String purOrgName;
    /**
     * 议价人名称
     */
    private String bargainingOperName;
    /**
     * 店铺ID
     */
    private String supplierShopId;
    /**
     * 店铺名称
     */
    private String supplierShopName;
    /**
     * 商品ID
     */
    private String commodityId;
    /**
     * 商品名称
     */
    private String commodityName;

    /**
     * 截止报价时间
     */
    private Date quotationExpiryTime;
    /**
     * 议价单状态
     1000 报价中
     1001 已报价
     1002 已终止
     1003 已下单
     */
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.BARGAINING_STATE.P_CODE)
    private String bargainingState;
    /**
     * 议价单状态
     1000 报价中
     1001 已报价
     1002 已终止
     1003 已下单
     */
    private String bargainingStateStr;
    /**
     * 报价（含税）
     */
    private BigDecimal confirmedPrice;
    /**
     * 报价小计
     */
    private BigDecimal confirmedPriceSub;
    /**
     * 单价折扣率
     */
    private BigDecimal discountRate;
}
