package com.tydic.dyc.oc.model.order.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderProcInst
 * 说明:订单流程实例
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderProcInst implements Serializable {
	private static final long serialVersionUID =  7727612635035685830L;

	//id")
	private Long id;

	//订单id")
	private Long orderId;

	//流程实例id")
	private String procInstId;

	//流程key定义")
	private String procDefId;

	//单据id")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//创建时间")
	private Date createTime;

	//当前环节")
	private String procState;

	//完结标志0未完结1已完结")
	private Integer finishTag;

	//完成时间")
	private Date finishTime;

	/**
	 * 所属中心:
	 AGR：协议
	 UOC：订单
	 UMC：会员
	 FSC：结算
	 UCC：商品
	 */
	private String centerCode;

}
