package com.tydic.dyc.oc.model.saleorder.sub;


import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocSaleOrderPayConf
 * 说明:销售单支付配置
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderPayConf implements Serializable {
	private static final long serialVersionUID =  -638231126442954506L;

	//id")
	private Long id;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//付款方式 0 预付款按比例支付,1 按协议约束支付,2 按账期支付")
	@DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.PAY_TYPE.P_CODE)
	private Integer payType;

	//付款方式翻译")
	private String payTypeStr;

	//预付款(比例)")
	private BigDecimal prePaySup;

	//到货款(比例)")
	private BigDecimal verPaySup;

	//验收款(比例)")
	private BigDecimal pilPaySup;

	//质保金(比例)")
	private BigDecimal quaPaySup;

	//预付款")
	private BigDecimal prePayFee;

	//到货款")
	private BigDecimal verPayFee;

	//验收款")
	private BigDecimal pilPayFee;

	//质保金")
	private BigDecimal quaPayFee;

	//预付款-已付")
	private BigDecimal prePayedFee;

	//到货款-已付")
	private BigDecimal verPayedFee;

	//验收款-已付")
	private BigDecimal pilPayedFee;

	//质保金-已付")
	private BigDecimal quaPayedFee;

	//账期天数")
	private Integer paymentDays;

	//指定账期日")
	private Integer payAccountDay;

	//使用类型：1：采购方；2：平台方")
	private Integer userType;

	//使用类型翻译")
	private String userTypeStr;

	//账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数")
	private Integer payRule;

	//账期支付结算规则翻译")
	private String payRuleStr;

	//违约金额比例")
	private BigDecimal payBreakScale;

	//账期日结算订单规则 1:签收发票开始 2:订单验收 3:订单到货")
	private Integer payAccountDayRule;

	//账期起算特定业务节点 1:签收发票开始计算 2:订单验收开始计算 3:订单到货开始计算")
	private Integer payNodeRule;

	//账期日结算订单规则翻译")
	private String payAccountDayRuleStr;

	//账期起算特定业务节点翻译")
	private String payNodeRuleStr;

	//合同ID")
	private String modelContractId;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;



}
