package com.tydic.dyc.oc.model.shiporder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderQryBo
 * 说明:发货单
 * 时间:2022-02-21 19:12
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocShipOrderQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  4479085140079952036L;

	//发货单id")
	private Long shipOrderId;


	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//发货单编码")
	private String shipOrderNo;

	//外部发货单编码")
	private String shipOrderNoExt;

	//发货单名称")
	private String shipOrderName;

	//发货单类型")
	private Integer shipOrderType;

	//订单状态")
	private String shipOrderState;

	//供应商编码")
	private String supNo;

	//供应商账户")
	private String supAccount;

	//物流公司id")
	private String shipCompanyId;

	//物流公司名称")
	private String shipCompanyName;

	//发货时间")
	private Date shipTime;

	//发货时间 开始")
	private Date shipTimeStart;

	//发货时间 结束")
	private Date shipTimeEnd;

	//发货联系人姓名")
	private String shipName;

	//发货联系人电话")
	private String shipPhone;

	//发货工号")
	private String shipOperId;

	//预计到货时间")
	private Date estimateArrivalTime;

	//预计到货时间 开始")
	private Date estimateArrivalTimeStart;

	//预计到货时间 结束")
	private Date estimateArrivalTimeEnd;

	//到货时间")
	private Date arriveTime;

	//到货时间 开始")
	private Date arriveTimeStart;

	//到货时间 结束")
	private Date arriveTimeEnd;

	//验收时间-该发货单全部被验收")
	private Date inspTime;

	//验收时间-该发货单全部被验收 开始")
	private Date inspTimeStart;

	//验收时间-该发货单全部被验收 结束")
	private Date inspTimeEnd;

	//验收人名称")
	private String inspOperName;

	//验收人工号")
	private String inspOperId;

	//验收人电话")
	private String inspOperPhone;

	//是否包含附件")
	private Integer isEnclosure;

	//发货备注")
	private String shipRemark;

	//到货备注")
	private String arriveRemark;

	//收/拒收 货人")
	private String receiverUser;

	//收/拒收 货备注")
	private String receiverRemark;

	//收/拒收 联系人")
	private String receiverContact;

	//收/拒收 时间")
	private Date receiverTime;

	//收/拒收 时间 开始")
	private Date receiverTimeStart;

	//收/拒收 时间 结束")
	private Date receiverTimeEnd;

	//是否可以异常变更：1：不允许；其他情况都可以")
	private Integer isAbnormal;

	//流转状态")
	private String procState;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//租户ID")
	private String tenantId;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单时间 开始")
	private Date cancelTimeStart;

	//撤单时间 结束")
	private Date cancelTimeEnd;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//备注")
	private String remark;

	//竣工时间")
	private Date finishTime;

	//竣工时间 开始")
	private Date finishTimeStart;

	//竣工时间 结束")
	private Date finishTimeEnd;

	//逾期时间")
	private Date expTime;

	//逾期时间 开始")
	private Date expTimeStart;

	//逾期时间 结束")
	private Date expTimeEnd;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//发货单idList")
	private List<Long> shipOrderIdList;
	
	private List<UocShipOrderItemQryBo> shipOrderItemBoList;
    
    //是否京东长直，1是，0否，默认0")
    private Integer jdCz;

}
