package com.tydic.dyc.oc.service.bargaining;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.service.bargaining.bo.UocBargainingCreateResultBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingCreateResultReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingCreateResultRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:订单领域服务-议价单申请结果查询服务实现
 * 说明:
 * 时间:2023/7/26 15:19
 * 作者:Dum
 */
@HTServiceImpl
public class UocQryBargainingCreateResultServiceImpl implements UocQryBargainingCreateResultService{
    @Autowired
    private IUocBargainingModel uocBargainingModel;
    /**
     * 议价单申请结果查询服务
     */
    @Override
    public UocQryBargainingCreateResultRspBo qryBargainingCreateResult(UocQryBargainingCreateResultReqBo uocQryBargainingCreateResultReqBo) {
        validatebarg(uocQryBargainingCreateResultReqBo);
        UocQryBargainingCreateResultRspBo resultRspBO = new UocQryBargainingCreateResultRspBo();
        UocBargainingQryBo uocBargainingQryBo =new UocBargainingQryBo();
            uocBargainingQryBo.setBargainingParentId(uocQryBargainingCreateResultReqBo.getBargainingParentId());
            uocBargainingQryBo.setBargainingOperId(String.valueOf(uocQryBargainingCreateResultReqBo.getUserId()));
            uocBargainingQryBo.setPurOrgId(uocQryBargainingCreateResultReqBo.getOrgId() != null ? uocQryBargainingCreateResultReqBo.getOrgId().toString() : null);
        List<UocBargaining> uocBargainingList = uocBargainingModel.getListBargaining(uocBargainingQryBo);
        if (!CollectionUtils.isEmpty(uocBargainingList)) {
            List<UocBargainingCreateResultBo> bargainingCreateResultBoList = new ArrayList<>();
            for (UocBargaining uocBargaining : uocBargainingList) {
                UocBargainingCreateResultBo createResultBO = new UocBargainingCreateResultBo();
                createResultBO.setBargainingId(uocBargaining.getBargainingId());
                createResultBO.setPurOrgId(uocBargaining.getPurOrgId());
                createResultBO.setBargainingNo(uocBargaining.getBargainingNo());
                createResultBO.setSupplierName(uocBargaining.getSupplierName());
                createResultBO.setTotalPrice(uocBargaining.getTotalPrice());
                bargainingCreateResultBoList.add(createResultBO);
            }
            resultRspBO.setUocBargainingList(bargainingCreateResultBoList);
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "议价单查询结果为空");
        }
        return resultRspBO;
    }
    private void validatebarg(UocQryBargainingCreateResultReqBo reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryBargainingCreateResultReqBO]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getBargainingParentId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【议价主单id】不能为空");
        }

    }
}
