package com.tydic.dyc.oc.service.cmporder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.cmporder.bo.SkuCmpOrderRelBO;
import com.tydic.dyc.oc.service.cmporder.bo.UocCopyCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCopyCmpOrderServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description 〈领域服务-复制比价，再次购买用〉
 * @author Luokan
 * @date 2024/02/27
 **/
@HTServiceImpl
public class UocCopyCmpOrderServiceImpl implements UocCopyCmpOrderService{

    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Autowired
    private IUocSaleOrderModel uocSaleOrderModel;

    @Override
    public UocCopyCmpOrderServiceRspBo dealCopyCmpOrder(UocCopyCmpOrderServiceReqBo reqBo) {
        UocCopyCmpOrderServiceRspBo rsp = new UocCopyCmpOrderServiceRspBo();
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderItem> qrtSaleItemResult = this.uocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(qrtSaleItemResult)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细为空！");
        }
        //过滤出有必选单的明细
        List<SkuCmpOrderRelBO> skuCmpOrderRelBOList = qrtSaleItemResult.stream().filter(bo -> null != bo.getCmpOrderNo()).map(bo -> {
            SkuCmpOrderRelBO skuCmpOrderRelBO = new SkuCmpOrderRelBO();
            skuCmpOrderRelBO.setSkuId(bo.getSkuId());
            skuCmpOrderRelBO.setCmpOrderNo(bo.getCmpOrderNo());
            return skuCmpOrderRelBO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuCmpOrderRelBOList)) {
            for (SkuCmpOrderRelBO bo : skuCmpOrderRelBOList) {
                //查询必选单详情
                UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
                uocCmpOrderQryBo.setCmpOrderNo(bo.getCmpOrderNo());
                UocCmpOrderQryBo qryCmpResult = this.uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
                if (null == qryCmpResult) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "必选单详情查询为空！");
                }
                //新增必选单
                UocCmpOrderDo uocCmpOrderDo = JSON.parseObject(JSON.toJSONString(qryCmpResult), UocCmpOrderDo.class);
                uocCmpOrderDo.setCreateTime(new Date());
                uocCmpOrderDo.setCreateOperName(reqBo.getName());
                uocCmpOrderDo.setCreateOperId(reqBo.getUserId().toString());
                uocCmpOrderDo.setCreateOrgId(String.valueOf(reqBo.getOrgId()));
                uocCmpOrderDo.setCreateOrgName(reqBo.getOrgName());
                uocCmpOrderDo.setUpdateTime(null);
                uocCmpOrderDo.setUpdateOperId(null);
                uocCmpOrderModel.createCmpOrder(uocCmpOrderDo);
                bo.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
            }
            rsp.setSkuCmpOrderRelBOList(skuCmpOrderRelBOList);
        }
        return rsp;
    }
}
