package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderCreateTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-售后申请实现〉
 * @author : yuhao
 * @date : 2022/9/10 13:14
 */
@HTServiceImpl
public class UocAfterOrderCreateServiceImpl implements UocAfterOrderCreateService{
    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    /**
     * 售后申请事务层
     */
    @Autowired
    private UocAfterOrderCreateTransaction uocAfterOrderCreateTransaction;

    @Override
    public UocAfterOrderCreateRspBo createAfterOrder(UocAfterOrderCreateReqBo reqBo) {
        //调用售后申请事务层，售后申请
        UocAfterOrderCreateRspBo rspBo = this.uocAfterOrderCreateTransaction.createAfterOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }
    /**
     * 同步ES
     */
    private void syncEs(UocAfterOrderCreateReqBo reqBo, UocAfterOrderCreateRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义销售单数据同步BO
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncSaleEsRunnableBo.setObjId(reqBo.getSaleOrderId());
        //设置操作标识
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);

        //定义发货单数据同步BO
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        //设置订单ID
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncShipEsRunnableBo.setObjId(reqBo.getShipOrderId());
        //设置操作标识
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncShipEsRunnableBo);

        //定义售后单数据同步BO
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        //设置订单ID
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncAfEsRunnableBo.setObjId(rspBo.getAfOrderId());
        //设置操作标识
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncAfEsRunnableBo);

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
