package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocNumChngOrderCreateForInspTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocNumChngOrderCreateServiceImpl
 * 说明:数量变更申请
 * 时间:2022/3/8 18:02
 * 作者:罗有
 */
@HTServiceImpl
public class UocNumChngOrderCreateForInspServiceImpl implements UocNumChngOrderCreateForInspService {
    @Autowired
    private UocNumChngOrderCreateForInspTransaction uocNumChngOrderCreateForInspTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocNumChngOrderCreateForInspRspBo createNumChng(UocNumChngOrderCreateForInspReqBo reqBo) {
        UocNumChngOrderCreateForInspRspBo rspBo = uocNumChngOrderCreateForInspTransaction.createNumChng(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }

        return rspBo;
    }

    private void syncEs(UocNumChngOrderCreateForInspReqBo reqBo, UocNumChngOrderCreateForInspRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        //同步变更单
        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(rspBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);

        //同步验收单
        List<Long> inspOrderIdList = rspBo.getInspOrderIdList();
        for (Long inspOrderId : inspOrderIdList) {
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(uocIndexConfig.getInspOrderIndex());
            saleOrderBo.setOrderId(reqBo.getOrderId());
            saleOrderBo.setObjId(inspOrderId);
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

