package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.transactionservice.UocShipOrderArrivaConfirmOrRefuseTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-发货单到货确认/拒收实现〉
 * @author : yuhao
 * @date : 2022/8/25 9:13
 */

@HTServiceImpl
@Slf4j
public class UocShipOrderArrivaConfirmOrRefuseServiceImpl implements UocShipOrderArrivaConfirmOrRefuseService {

	@Autowired
	private UocShipOrderArrivaConfirmOrRefuseTransaction uocShipOrderArrivaConfirmOrRefuseTransaction;
	@Autowired
	private UocThreadPool uocThreadPool;
	@Autowired
	private UocIndexConfig uocIndexConfig;

	@Override
	public UocShipOrderArrivaConfirmOrRefuseRspBo dealArriva(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
		UocShipOrderArrivaConfirmOrRefuseRspBo rspBo = uocShipOrderArrivaConfirmOrRefuseTransaction.dealArriva(reqBo);
		if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
			//本地线程同步es
			syncEs(reqBo, rspBo);
		}
		return rspBo;
	}

	private void syncEs(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, UocShipOrderArrivaConfirmOrRefuseRspBo rspBo) {
		List<SyncEsRunnableBo> list = new ArrayList<>();
		//同步销售单
		SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
		saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
		saleBo.setOrderId(reqBo.getOrderId());
		saleBo.setObjId(reqBo.getSaleOrderId());
		saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
		list.add(saleBo);
		//同步发货单
		if (!CollectionUtils.isEmpty(reqBo.getShipOrderIdList())) {
			for (Long shipOrderId : reqBo.getShipOrderIdList()) {
				SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
				shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
				shipBo.setOrderId(reqBo.getOrderId());
				shipBo.setObjId(shipOrderId);
				shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
				list.add(shipBo);
			}
		}

		uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
	}
}
