package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAgrOrderFinishReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAgrOrderFinishRspBO;
import com.tydic.dyc.oc.transactionservice.UocDealAgrOrderFinishTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @description 南水北调协议完成接口
 * @author Luokan
 * @date 2024/07/10
 **/
@HTServiceImpl
public class UocDealAgrOrderFinishServiceImpl implements UocDealAgrOrderFinishService{

    @Autowired
    private UocDealAgrOrderFinishTransaction uocDealAgrOrderFinishTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocDealAgrOrderFinishRspBO dealAgrOrderFinish(UocDealAgrOrderFinishReqBO reqBO) {
        UocDealAgrOrderFinishRspBO rspBo = uocDealAgrOrderFinishTransaction.dealAgrOrderFinish(reqBO);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealAgrOrderFinishReqBO reqBO, UocDealAgrOrderFinishRspBO rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        orderBo.setOrderId(reqBO.getOrderId());
        orderBo.setObjId(reqBO.getSaleOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
