package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.constants.UocSystemConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqSkuBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-电商预定单下单成功处理服务 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
@Slf4j
public class UocResoveEsPreOrderServiceImpl implements UocResoveEsPreOrderService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Value("${dyc.system.name:DYC}")
    private String systemName;

    @Override
    public UocResoveEsPreOrderServiceRspBo dealEsPreOrder(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocResoveEsPreOrderServiceRspBo rspBo = UocRu.success(UocResoveEsPreOrderServiceRspBo.class);

        if(UocConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())){
            UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_XD_SB);
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);
            //北控，罗侃已确认bug修改
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setSaleOrderId(reqBo.getSaleOrderId());
            rspBo.setOutOrderId(reqBo.getOutOrderId());
            return rspBo;
        }

        // 更新销售单item裸价，税率，税金
        UocSaleOrderDo updatSaleItemBo = assembleUpdateDo(reqBo);
        iUocSaleOrderModel.updateSaleItemWithOutSkuId(updatSaleItemBo);

        // 更新销售单表外部订单id
        UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
        updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
        updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
        updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
        iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);

        // 保存外部订单id和内部订单关系
        UocOrderQueryIndex index = new UocOrderQueryIndex();
        index.setId(IdUtil.nextId());
        index.setOrderId(reqBo.getOrderId());
        index.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        index.setObjId(reqBo.getSaleOrderId());
        index.setOutObjId(reqBo.getOutOrderId());
        iUocCommonModel.saveOrderQueryIndex(index);

        //出参
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());

        return rspBo;
    }

    private UocSaleOrderDo assembleUpdateDo(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocSaleOrderDo updateSaleItemBo = new UocSaleOrderDo();
        updateSaleItemBo.setOrderId(reqBo.getOrderId());
        updateSaleItemBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocResoveEsPreOrderServiceReqSkuBo> sku = reqBo.getSku();
        List<UocSaleOrderItem> saleItemList = new ArrayList<>();
        updateSaleItemBo.setSaleOrderItems(saleItemList);
        for (UocResoveEsPreOrderServiceReqSkuBo skuBo : sku) {
            UocSaleOrderItem item = new UocSaleOrderItem();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());

            item.setTax(new BigDecimal(skuBo.getTax()));
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            saleItemList.add(item);
        }
        return updateSaleItemBo;
    }
}


