package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAgrOrderFinishReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAgrOrderFinishRspBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
@Slf4j
public class UocDealAgrOrderFinishTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocDealAgrOrderFinishRspBO dealAgrOrderFinish(UocDealAgrOrderFinishReqBO reqBO) {
        UocDealAgrOrderFinishRspBO rspBO = new UocDealAgrOrderFinishRspBO();

        //更新销售单主体信息,供应商确认/拒单人，确认/拒单时间，拒单原因
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setOrderId(reqBO.getOrderId());
        updateUocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_YS);
        updateUocSaleOrderDo.setUpdateOperId(reqBO.getUserId().toString());
        updateUocSaleOrderDo.setUpdateOperName(reqBO.getName());
        updateUocSaleOrderDo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);

        //提交任务
        this.commitTask(reqBO);

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void commitTask(UocDealAgrOrderFinishReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }
}
