package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.config.UocPropertiesConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrderRepositoryImpl
 * 说明:验收单
 * 时间:2022/2/21 18:53
 * 作者:罗有
 */
@Slf4j
@Service
public class UocInspOrderRepositoryImpl implements UocInspOrderRepository {
    @Autowired
    private UocInspOrderMapper uocInspOrderMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocInspOrderMapMapper uocInspOrderMapMapper;
    @Autowired
    private UocInspItemMapMapper uocInspItemMapMapper;
    @Autowired
    private UocShipInspRelMapper uocShipInspRelMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;


    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        uocInspOrderMapper.insert(UocRu.js(uocInspOrderDo, UocInspOrderPo.class));
        uocInspOrderItemMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocInspOrderItemList(), UocInspOrderItemPo.class));
        if(ObjectUtil.isNotEmpty(uocInspOrderDo.getUocShipInspRelList())){
            uocShipInspRelMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocShipInspRelList(), UocShipInspRelPo.class));
        }
        if (!CollectionUtils.isEmpty(uocInspOrderDo.getExtParallelBoList())) {
            uocInspOrderMapMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getExtParallelBoList(), UocInspOrderMapPo.class));
        }
        List<UocInspItemMapPo> inspItemMapPoList = new ArrayList<>();
        uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
            if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                inspItemMapPoList.addAll(UocRu.jsl(uocInspOrderItem.getItemExtParallelBoList(), UocInspItemMapPo.class));
            }
        });
        if (!CollectionUtils.isEmpty(inspItemMapPoList)) {
            uocInspItemMapMapper.insertBatch(inspItemMapPoList);
        }
    }

    @Override
    public void createInspOrderItem(UocInspOrderDo uocInspOrderDo) {
        uocInspOrderItemMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocInspOrderItemList(), UocInspOrderItemPo.class));
        if(ObjectUtil.isNotEmpty(uocInspOrderDo.getUocShipInspRelList())){
            uocShipInspRelMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocShipInspRelList(), UocShipInspRelPo.class));
        }
        if (!CollectionUtils.isEmpty(uocInspOrderDo.getExtParallelBoList())) {
            uocInspOrderMapMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getExtParallelBoList(), UocInspOrderMapPo.class));
        }
        List<UocInspItemMapPo> inspItemMapPoList = new ArrayList<>();
        uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
            if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                inspItemMapPoList.addAll(UocRu.jsl(uocInspOrderItem.getItemExtParallelBoList(), UocInspItemMapPo.class));
            }
        });
        if (!CollectionUtils.isEmpty(inspItemMapPoList)) {
            uocInspItemMapMapper.insertBatch(inspItemMapPoList);
        }
    }

    @Override
    public void updateInspOrderItem(UocInspOrderDo uocInspOrderDo) {
        if (CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "要更新的验收单明细为空");
        }
        for (UocInspOrderItem each : uocInspOrderDo.getUocInspOrderItemList()) {

            if(each.getInspOrderId() == null
                    && each.getInspOrderItemId() == null
                    && each.getOrderId() == null
                    && each.getSaleOrderId() == null
                    && each.getSaleOrderItemId() == null
                    && each.getShipOrderItemId() == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "更新条件不能为空");
            }

            UocInspOrderItemPo set = JUtil.js(each, UocInspOrderItemPo.class);

            UocInspOrderItemPo where = new UocInspOrderItemPo();
            where.setInspOrderId(each.getInspOrderId());
            where.setInspOrderItemId(each.getInspOrderItemId());
            where.setOrderId(each.getOrderId());
            where.setSaleOrderId(each.getSaleOrderId());
            where.setSaleOrderItemId(each.getSaleOrderItemId());
            where.setShipOrderItemId(each.getShipOrderItemId());
            uocInspOrderItemMapper.updateBy(set, where);
        }
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = new UocInspOrderPo();
        uocInspOrderPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
        uocInspOrderPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
        uocInspOrderPo = uocInspOrderMapper.getModelBy(uocInspOrderPo);
        UocInspOrderDo uocInspOrderDo = UocRu.js(uocInspOrderPo, UocInspOrderDo.class);
        if (null != uocInspOrderPo) {
            UocInspOrderMapPo uocInspOrderMapPo = new UocInspOrderMapPo();
            uocInspOrderMapPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            uocInspOrderMapPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
            List<UocInspOrderMapPo> uocInspOrderMapPoList = uocInspOrderMapMapper.getList(uocInspOrderMapPo);
            uocInspOrderDo.setExtParallelBoList(UocRu.jsl(uocInspOrderMapPoList, UocInspOrderMap.class));

            UocShipInspRelPo uocShipInspRelPo = new UocShipInspRelPo();
            uocShipInspRelPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            uocShipInspRelPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
            List<UocShipInspRelPo> uocShipInspRelPoList = uocShipInspRelMapper.getList(uocShipInspRelPo);
            uocInspOrderDo.setUocShipInspRelList(UocRu.jsl(uocShipInspRelPoList, UocShipInspRel.class));

            UocOrderAccessoryPo uocOrderAccessoryPo = new UocOrderAccessoryPo();
            uocOrderAccessoryPo.setOrderId(uocInspOrderQryBo.getOrderId());
            uocOrderAccessoryPo.setObjId(uocInspOrderQryBo.getInspOrderId());
            uocOrderAccessoryPo.setDataAchiveTabSuffix(uocInspOrderQryBo.getDataAchiveTabSuffix());
            List<UocOrderAccessoryPo> accessoryList = uocOrderAccessoryMapper.getList(uocOrderAccessoryPo);
            if(!CollectionUtils.isEmpty(accessoryList)){
                uocInspOrderDo.setUocOrderAccessoryList(UocRu.jsl(accessoryList, UocOrderAccessory.class));
            }

        }
        return uocInspOrderDo;
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        List<UocInspOrderItemPo> uocInspOrderItemPoList = uocInspOrderItemMapper.getList(UocRu.js(uocInspOrderItemQryBo, UocInspOrderItemPo.class));
        log.info("验收单明细列表查询mapper返回：{}", JSON.toJSONString(uocInspOrderItemPoList));
        if (!CollectionUtils.isEmpty(uocInspOrderItemPoList)){
            uocInspOrderItemPoList.forEach(v->v.setInspItemCount(v.getInspCount()));
        }
        uocInspOrderDo.setUocInspOrderItemList(UocRu.jsl(uocInspOrderItemPoList, UocInspOrderItem.class));
//        List<Long> inspItemOrderIdList = uocInspOrderItemPoList.stream().map(UocInspOrderItemPo::getImplOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(inspItemOrderIdList)) {
//            UocInspItemMapPo uocInspItemMapPo = new UocInspItemMapPo();
//            uocInspItemMapPo.setInspOrderItemIdList(inspItemOrderIdList);
//            List<UocInspItemMapPo> uocInspItemMapPoList = uocInspItemMapMapper.getList(uocInspItemMapPo);
//            if (!CollectionUtils.isEmpty(uocInspItemMapPoList)) {
//                ConcurrentMap<Long, List<UocInspItemMapPo>> uocInspItemMap =
//                        uocInspItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocInspItemMapPo::getInspOrderItemId));
//                uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem ->
//                        uocInspOrderItem.setItemExtParallelBoList(UocRu.jsl(uocInspItemMap.get(uocInspOrderItem.getInspOrderItemId()), UocInspItemMap.class)));
//            }
//        }
        return uocInspOrderDo;
    }
    @Override
    public UocInspOrderDo getInspOrderItemList(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        List<UocInspOrderItemPo> uocInspOrderItemPoList = uocInspOrderItemMapper.getItemList(UocRu.js(uocInspOrderItemQryBo, UocInspOrderItemPo.class));
        log.info("验收单明细列表查询mapper返回：{}", JSON.toJSONString(uocInspOrderItemPoList));

        if (!CollectionUtils.isEmpty(uocInspOrderItemPoList)){
            uocInspOrderItemPoList.forEach(v->v.setInspCount(v.getInspItemCount()));
        }
        uocInspOrderDo.setUocInspOrderItemList(UocRu.jsl(uocInspOrderItemPoList, UocInspOrderItem.class));
        return uocInspOrderDo;
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        List<UocInspOrderPo> uocInspOrderPoList = uocInspOrderMapper.getList(UocRu.js(uocInspOrderQryBo, UocInspOrderPo.class));
        return UocRu.jsl(uocInspOrderPoList, UocInspOrderDo.class);
    }

    @Override
    public UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = UocRu.js(uocInspOrderQryBo, UocInspOrderPo.class);
        uocInspOrderPo = uocInspOrderMapper.qryTotalFeeAndCount(uocInspOrderPo);
        return UocRu.js(uocInspOrderPo, UocInspOrderDo.class);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocInspOrderItem uocSaleOrderItem) {
        UocInspOrderItemPo uocInspOrderItemPo = new UocInspOrderItemPo();
        uocInspOrderItemPo.setOrderId(uocSaleOrderItem.getOrderId());
        uocInspOrderItemPo.setInspOrderItemId(uocSaleOrderItem.getInspOrderItemId());
        uocInspOrderItemPo = uocInspOrderItemMapper.getModelBy(uocInspOrderItemPo);
        UocInspOrderItemPo set = new UocInspOrderItemPo();
        set.setReturnCount(uocInspOrderItemPo.getReturnCount().subtract(uocSaleOrderItem.getReturnCount()));
        set.setUpdateTime(uocSaleOrderItem.getUpdateTime());
        set.setUpdateOperId(uocSaleOrderItem.getUpdateOperId());
        UocInspOrderItemPo where = new UocInspOrderItemPo();
        where.setOrderId(uocSaleOrderItem.getOrderId());
        where.setInspOrderItemId(uocSaleOrderItem.getInspOrderItemId());
        uocInspOrderItemMapper.updateBy(set, where);
    }

    @Override
    public void modifyInspOrderItemChngingCount(UocInspOrderDo inspOrderDo) {
        uocInspOrderItemMapper.modifyInspOrderItemChngingCount(UocRu.jsl(inspOrderDo.getUocInspOrderItemList(), UocInspOrderItem.class), UocRu.js(inspOrderDo, UocInspOrderItem.class));
    }

    @Override
    public void modifyItemChngCountRefuse(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemChngCountRefuse(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
    }

    @Override
    public void modifyItemChngCountConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemChngCountConfirm(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
    }

    @Override
    public void modifyBatchItemInspConfirm(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyBatchItemInspConfirm(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
        uocInspOrderMapper.modifyInspPrice(UocRu.js(convertInspOrderDo,UocInspOrderPo.class));
    }

    @Override
    public void modifyItemChngCountConfirmAdd(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemChngCountConfirmAdd(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
    }
    @Override
    public void modifyItemChngCountConfirmReduce(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemChngCountConfirmReduce(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));
    }
    @Override
    public void modifyInsporderChngTotalFeeConfirm(UocInspOrderDo convertInspOrderDo) {
        if (convertInspOrderDo.getTotalSaleFee().compareTo(BigDecimal.ZERO) >= 0){
            uocInspOrderItemMapper.modifyInsporderChngTotalFeeConfirm(UocRu.js(convertInspOrderDo,UocInspOrderItem.class),1);
        }else {
            uocInspOrderItemMapper.modifyInsporderChngTotalFeeConfirm(UocRu.js(convertInspOrderDo,UocInspOrderItem.class),2);
        }
    }

    @Override
    public void updateInspPayStatus(UocInspOrderDo updateDo) {
        UocInspOrderPo set = new UocInspOrderPo();
        set.setPayStatus(updateDo.getPayStatus());
        set.setUpdateTime(new Date());
        UocInspOrderPo where = new UocInspOrderPo();
        where.setOrderId(updateDo.getOrderId());
        where.setInspOrderId(updateDo.getInspOrderId());
        uocInspOrderMapper.updateBy(set, where);
    }

    @Autowired
    private UocPropertiesConfig uocPropertiesConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public void batchSyncInsp() {
        int pageSize = uocPropertiesConfig.getSyncEsPageSize();

        //第一页
        Page<UocInspOrderPo> page = new Page<>(uocPropertiesConfig.getSyncEsPageStart(),pageSize);
        List<UocInspOrderPo> listPage = uocInspOrderMapper.getListPage(new UocInspOrderPo(), page);
        syncSaleEs(listPage);

        //第N页
        for (int i = 2; i <= page.getTotalPages(); i++) {
            Page<UocInspOrderPo> pageInner = new Page<>(i, pageSize);
            List<UocInspOrderPo> innerList = uocInspOrderMapper.getListPage(new UocInspOrderPo(), pageInner);
            syncSaleEs(innerList);
        }

    }

    @Override
    public void modifyItemRemainCountAdd(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemRemainCountAdd(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));

    }

    @Override
    public void modifyItemRemainCountReduce(UocInspOrderDo convertInspOrderDo) {
        uocInspOrderItemMapper.modifyItemRemainCountReduce(UocRu.js(convertInspOrderDo,UocInspOrderItem.class));

    }

    @Override
    public void updateInspRemark(UocInspOrderDo convertInspOrderDo) {
        UocInspOrderPo set = new UocInspOrderPo();
        set.setRemark(convertInspOrderDo.getRemark());
        set.setUpdateTime(new Date());
        UocInspOrderPo where = new UocInspOrderPo();
        where.setOrderId(convertInspOrderDo.getOrderId());
        where.setInspOrderId(convertInspOrderDo.getInspOrderId());
        uocInspOrderMapper.updateBy(set, where);
    }

    private void syncSaleEs(List<UocInspOrderPo> listPage) {
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();
        for (UocInspOrderPo uocSaleOrderPo : listPage) {
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(uocSaleOrderPo.getOrderId());
            signleSync.setObjId(uocSaleOrderPo.getInspOrderId());
            signleSync.setIndexName(uocIndexConfig.getInspOrderIndex());
            syncEsRunnableBoList.add(signleSync);
        }
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
