package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderPo
 * 说明:发货单
 * 时间:2022-05-20 10:11
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocShipOrderPo implements Serializable {
	private static final long serialVersionUID = -5730044681154456369L;

	//发货单id")
	private Long shipOrderId;

	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//发货单编码")
	private String shipOrderNo;

	//外部发货单编码")
	private String shipOrderNoExt;

	//发货单名称")
	private String shipOrderName;

	//发货单类型")
	private Integer shipOrderType;

	//订单状态")
	private String shipOrderState;

	//供应商编码")
	private String supNo;

	//供应商账户")
	private String supAccount;

	//物流公司id")
	private String shipCompanyId;

	//物流公司名称")
	private String shipCompanyName;

	//发货时间")
	private Date shipTime;

	//发货时间 开始")
	private Date shipTimeStart;

	//发货时间 结束")
	private Date shipTimeEnd;

	//发货联系人姓名")
	private String shipName;

	//发货联系人电话")
	private String shipPhone;

	//发货工号")
	private String shipOperId;

	//预计到货时间")
	private Date estimateArrivalTime;

	//预计到货时间 开始")
	private Date estimateArrivalTimeStart;

	//预计到货时间 结束")
	private Date estimateArrivalTimeEnd;

	//到货时间")
	private Date arriveTime;

	//到货时间 开始")
	private Date arriveTimeStart;

	//到货时间 结束")
	private Date arriveTimeEnd;

	//验收时间-该发货单全部被验收")
	private Date inspTime;

	//验收时间-该发货单全部被验收 开始")
	private Date inspTimeStart;

	//验收时间-该发货单全部被验收 结束")
	private Date inspTimeEnd;

	//是否包含附件")
	private Integer isEnclosure;

	//发货备注")
	private String shipRemark;

	//到货备注")
	private String arriveRemark;

	//验收人电话")
	private String inspOperPhone;

	//验收人名字")
	private String inspOperId;

	//验收人名称")
	private String inspOperName;

	//收/拒收 货人")
	private String receiverUser;

	//收/拒收 货备注")
	private String receiverRemark;

	//收/拒收 联系人")
	private String receiverContact;

	//收/拒收 时间")
	private Date receiverTime;

	//收/拒收 时间 开始")
	private Date receiverTimeStart;

	//收/拒收 时间 结束")
	private Date receiverTimeEnd;

	//是否可以异常变更：1：不允许；其他情况都可以")
	private Integer isAbnormal;

	//流转状态")
	private String procState;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//租户ID")
	private String tenantId;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//撤单时间")
	private Date cancelTime;

	//撤单时间 开始")
	private Date cancelTimeStart;

	//撤单时间 结束")
	private Date cancelTimeEnd;

	//撤单工号")
	private String cancelOperId;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//物流单号")
	private String shipCompanyNo;

	//车牌号")
	private String carNo;

	//运输方式，1汽运，2三方物流")
	private Integer transportMode;

	//允许变更时限")
	private Date allowChngTime;

	//允许变更时限 开始")
	private Date allowChngTimeStart;

	//允许变更时限 结束")
	private Date allowChngTimeEnd;

	//备注")
	private String remark;

	//竣工时间")
	private Date finishTime;

	//竣工时间 开始")
	private Date finishTimeStart;

	//竣工时间 结束")
	private Date finishTimeEnd;

	//逾期时间")
	private Date expTime;

	//逾期时间 开始")
	private Date expTimeStart;

	//逾期时间 结束")
	private Date expTimeEnd;

	//扩展字段1")
	private String extField1;

	//扩展字段2")
	private String extField2;

	//扩展字段3")
	private String extField3;

	//扩展字段4")
	private String extField4;

	//扩展字段5")
	private String extField5;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//发货单IDList")
	private List<Long> shipOrderIdList;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;

}
