var cashierDeskInfo = null;

var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
$(document).ready(function () {
    // 返回收银台
    $("#payment_a").on("click", function () {
        window.history.back();
    });
    $('#submitBtn').on('click', paySubmit);
    $('#payerAcctNo, #clientName').on('keyup', function (e) {
        if (e.keyCode == 13) {
            paySubmit();
        }
    });

    init();
    $("#payerAcctNo").focus();
});

var init = function () {
    $('#orderId').text(payOrderInfo.orderId);
    $('#realFee').text(payOrderInfo.realFee / 100.00);

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/cashierDesk/queryCashierDesk';
    data.successF = function (returnData) {
        cashierDeskInfo = returnData;
        util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
                    window.history.back();
                });
            }
        });
    };
    loadingMask('正在获取支付信息...');
    util.ajax(data);
};

var paySubmit = function () {
    var payerAcctNo = $('#payerAcctNo').val();
    var clientName = $('#clientName').val();
    var comfirmUser = $('#confirmUser').val();
    var remitProvince = $('#remitProvince').val();
    var remitCity = $('#remitCity').val();
    if (payerAcctNo == '') {
        util.dialog.alert('请输入付款人账号');
        return;
    }
    if (payerAcctNo.length > 34) {
        util.dialog.alert('付款人账号不能超过34位');
        return;
    }
    if (clientName == '') {
        util.dialog.alert('请输入付款人名称');
        return;
    }
    if (clientName.length > 140) {
        util.dialog.alert('付款人名称不能超过140位');
        return;
    }
    if (comfirmUser == '') {
        util.dialog.alert('请输入提交人名称');
        return;
    }
    if (comfirmUser.length > 140) {
        util.dialog.alert('提交人名称不能超过140位');
        return;
    }
    if (remitProvince == '') {
        util.dialog.alert('请输入汇出省');
        return;
    }
    if (remitCity == '') {
        util.dialog.alert('请输入汇出市');
        return;
    }
    var busiReqData = {
        payerAcctNo: payerAcctNo,
        clientName: clientName,
        cnncCommitter:comfirmUser,
        remitProvince:remitProvince,
        remitCity:remitCity
    };
    var data = {};
    data.params = {
        busiCode: cashierDeskInfo.busiCode,
        merchantId: cashierDeskInfo.merchantId,
        outOrderId: cashierDeskInfo.outOrderId,
        totalFee: parseInt(cashierDeskInfo.totalFee),
        payMethod: payOrderInfo.payMethod,
        reqWay: cashierDeskInfo.reqWay,
        detailName: cashierDeskInfo.detailName,
        channelId: cashierDeskInfo.channelId,
        cityId: cashierDeskInfo.cityId,
        createOperId: cashierDeskInfo.createOperId,
        // createOperIdName: cashierDeskInfo.createOperIdName,
        districtId: cashierDeskInfo.districtId,
        provinceId: cashierDeskInfo.provinceId,
        notifyUrl: cashierDeskInfo.notifyUrl,
        redirectUrl: cashierDeskInfo.redirectUrl,
        busiReqData: JSON.stringify(busiReqData)
    };
    data.params.service = '/payPro/dealOrder';
    data.contentType = 'json';
    data.successF = function (returnData) {
        var busiRspData = JSON.parse(returnData.busiRspData);
        location.href = busiRspData.webUrl;
        loadingMask("正在跳转...");
        setTimeout(function() {
            hideLoadingMask();
        }, 10000);
    };
    loadingMask("等待支付结果...");
    util.ajax(data);

    //调用会员中心接口 存储付款方相关信息
};
