/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.einvoice.impl;

import com.alibaba.fastjson.JSON;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.AlibabaEinvoiceApplyGetRequest;
import com.taobao.api.response.AlibabaEinvoiceApplyGetResponse;
import com.tydic.pfsc.external.api.einvoice.IfcGetEinvoiceApplyIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceApplyBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcGetEinvoiceApplyReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcGetEinvoiceApplyRspBO;
import com.tydic.pfsc.external.common.einvoice.base.IfcEinvoiceTaoBaoClient;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ifcGetEinvoiceApplyService")
public class IfcGetEinvoiceApplyIntfServiceImpl
implements IfcGetEinvoiceApplyIntfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcGetEinvoiceApplyIntfServiceImpl.class);

    @Override
    public IfcGetEinvoiceApplyRspBO getEinvoiceApply(IfcGetEinvoiceApplyReqBO reqBo) {
        AlibabaEinvoiceApplyGetResponse rsp;
        LOGGER.debug("\u83b7\u53d6\u5f00\u7968\u7533\u8bf7\u6570\u636e\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        IfcGetEinvoiceApplyRspBO rspBo = new IfcGetEinvoiceApplyRspBO();
        String validateArgStr = this.validateArg(reqBo);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBo.setIsSuccess(false);
            rspBo.setApplyList(new ArrayList<IfcEinvoiceApplyBO>());
            rspBo.setCode("7777");
            rspBo.setMsg(validateArgStr);
            rspBo.setSubCode("7777");
            rspBo.setSubMsg(validateArgStr);
            return rspBo;
        }
        DefaultTaobaoClient client = IfcEinvoiceTaoBaoClient.getInstance();
        String sessionKey = IfcEinvoiceTaoBaoClient.getSessionKey();
        AlibabaEinvoiceApplyGetRequest req = this.buildReqParams(reqBo);
        LOGGER.debug("\u7ec4\u88c5\u540e\u8c03\u7528taobao\u83b7\u53d6\u5f00\u7968\u7533\u8bf7\u6570\u636e\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        try {
            rsp = (AlibabaEinvoiceApplyGetResponse)client.execute((TaobaoRequest)req, sessionKey);
            LOGGER.debug("\u8c03\u7528taobao\u83b7\u53d6\u5f00\u7968\u7533\u8bf7\u6570\u636e\u670d\u52a1\u54cd\u5e94\u51fa\u53c2\uff1a{}", (Object)rsp.getBody());
        }
        catch (ApiException e) {
            rspBo.setIsSuccess(false);
            rspBo.setApplyList(new ArrayList<IfcEinvoiceApplyBO>());
            rspBo.setCode(e.getErrCode());
            rspBo.setMsg(e.getErrMsg());
            rspBo.setSubCode(e.getSubErrCode());
            rspBo.setSubMsg(e.getSubErrMsg());
            rspBo.setRespCode("0002");
            rspBo.setRespDesc(e.getSubErrMsg());
            return rspBo;
        }
        return this.buildRspParams(rspBo, rsp);
    }

    private IfcGetEinvoiceApplyRspBO buildRspParams(IfcGetEinvoiceApplyRspBO rspBo, AlibabaEinvoiceApplyGetResponse rsp) {
        rspBo.setIsSuccess(null == rsp ? false : rsp.getIsSuccess());
        ArrayList<IfcEinvoiceApplyBO> applyList = new ArrayList<IfcEinvoiceApplyBO>();
        if (null != rsp && !CollectionUtils.isEmpty((Collection)rsp.getApplyList())) {
            for (AlibabaEinvoiceApplyGetResponse.Apply apply : rsp.getApplyList()) {
                IfcEinvoiceApplyBO einvoiceApply = new IfcEinvoiceApplyBO();
                einvoiceApply.setBusinessType(apply.getBusinessType());
                einvoiceApply.setExtendProps(apply.getExtendProps());
                einvoiceApply.setGmtCreate(apply.getGmtCreate());
                einvoiceApply.setGmtModifiedStr(apply.getGmtModifiedStr());
                einvoiceApply.setInvoiceAmount(apply.getInvoiceAmount());
                einvoiceApply.setInvoiceKind(apply.getInvoiceKind());
                einvoiceApply.setInvoiceType(apply.getInvoiceType());
                einvoiceApply.setMemo(apply.getMemo());
                einvoiceApply.setPayerAddress(apply.getPayerAddress());
                einvoiceApply.setPayerBank(apply.getPayerBank());
                einvoiceApply.setPayerBankaccount(apply.getPayerBankaccount());
                einvoiceApply.setPayerName(apply.getPayerName());
                einvoiceApply.setPayerPhone(apply.getPayerPhone());
                einvoiceApply.setPayerRegisterNo(apply.getPayerRegisterNo());
                einvoiceApply.setPlatformCode(apply.getPlatformCode());
                einvoiceApply.setPlatformTid(apply.getPlatformTid());
                einvoiceApply.setStatus(apply.getStatus());
                einvoiceApply.setSumPrice(apply.getSumPrice());
                einvoiceApply.setSumTax(apply.getSumTax());
                einvoiceApply.setTriggerStatus(apply.getTriggerStatus());
                ArrayList<IfcEinvoiceItemBO> einvoiceItemList = new ArrayList<IfcEinvoiceItemBO>();
                if (!CollectionUtils.isEmpty((Collection)apply.getInvoiceItems())) {
                    for (AlibabaEinvoiceApplyGetResponse.InvoiceItem invoiceItem : apply.getInvoiceItems()) {
                        IfcEinvoiceItemBO einvoiceItem = new IfcEinvoiceItemBO();
                        einvoiceItem.setItemName(invoiceItem.getItemName());
                        einvoiceItem.setPrice(invoiceItem.getPrice());
                        einvoiceItem.setQuantity(invoiceItem.getQuantity());
                        einvoiceItem.setRowType(invoiceItem.getRowType());
                        einvoiceItem.setSpecification(invoiceItem.getSpecification());
                        einvoiceItem.setSumPrice(invoiceItem.getSumPrice());
                        einvoiceItem.setTax(invoiceItem.getTax());
                        einvoiceItem.setTaxRate(invoiceItem.getTaxRate());
                        einvoiceItem.setUnit(invoiceItem.getUnit());
                        einvoiceItem.setAmount(invoiceItem.getAmount());
                        einvoiceItem.setBizOrderId(invoiceItem.getBizOrderId());
                        einvoiceItem.setIsPostFeeRow(invoiceItem.getRowType());
                        einvoiceItemList.add(einvoiceItem);
                    }
                }
                einvoiceApply.setInvoiceItems(einvoiceItemList);
                applyList.add(einvoiceApply);
            }
        }
        rspBo.setApplyList(applyList);
        rspBo.setRequestId(null == rsp ? null : rsp.getRequestId());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private AlibabaEinvoiceApplyGetRequest buildReqParams(IfcGetEinvoiceApplyReqBO reqBo) {
        AlibabaEinvoiceApplyGetRequest req = new AlibabaEinvoiceApplyGetRequest();
        req.setApplyId(reqBo.getApplyId());
        req.setPlatformTid(reqBo.getPlatformTid());
        return req;
    }

    private String validateArg(IfcGetEinvoiceApplyReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPlatformTid())) {
            return "\u5e73\u53f0\u8ba2\u5355\u53f7[platformTid]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

