/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.einvoice.impl;

import com.alibaba.fastjson.JSON;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.AlibabaEinvoiceCreatereqRequest;
import com.taobao.api.response.AlibabaEinvoiceCreatereqResponse;
import com.tydic.pfsc.external.api.einvoice.IfcReqCreateEinvoiceIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcReqCreateEinvoiceRspBO;
import com.tydic.pfsc.external.common.einvoice.base.IfcEinvoiceTaoBaoClient;
import com.tydic.pfsc.external.common.einvoice.constants.IfcEinvoiceConstants;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ifcReqCreateEinvoiceService")
public class IfcReqCreateEinvoiceIntfServiceImpl
implements IfcReqCreateEinvoiceIntfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcReqCreateEinvoiceIntfServiceImpl.class);

    @Override
    public IfcReqCreateEinvoiceRspBO requestToCreateEinvoice(IfcReqCreateEinvoiceReqBO reqBo) {
        AlibabaEinvoiceCreatereqResponse rsp;
        LOGGER.debug("\u53d1\u8d77\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        IfcReqCreateEinvoiceRspBO rspBo = new IfcReqCreateEinvoiceRspBO();
        String validateArgStr = this.validateArg(reqBo);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBo.setIsSuccess(false);
            rspBo.setCode("7777");
            rspBo.setMsg(validateArgStr);
            rspBo.setSubCode("7777");
            rspBo.setSubMsg(validateArgStr);
            return rspBo;
        }
        DefaultTaobaoClient client = IfcEinvoiceTaoBaoClient.getInstance();
        String sessionKey = IfcEinvoiceTaoBaoClient.getSessionKey();
        AlibabaEinvoiceCreatereqRequest req = this.buildReqParams(reqBo);
        LOGGER.debug("\u7ec4\u88c5\u540e\u8c03\u7528taobao\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        try {
            rsp = (AlibabaEinvoiceCreatereqResponse)client.execute((TaobaoRequest)req, sessionKey);
            LOGGER.debug("\u8c03\u7528taobao\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u54cd\u5e94\u51fa\u53c2\uff1a{}", (Object)rsp.getBody());
            if (rsp.getSubMsg() != null) {
                rspBo.setSubMsg(rsp.getSubMsg());
            }
        }
        catch (ApiException e) {
            rspBo.setIsSuccess(false);
            rspBo.setCode(e.getErrCode());
            rspBo.setMsg(e.getErrMsg());
            rspBo.setSubCode(e.getSubErrCode());
            rspBo.setSubMsg(e.getSubErrMsg());
            rspBo.setRespCode("0002");
            rspBo.setRespDesc(e.getSubErrMsg());
            return rspBo;
        }
        rspBo.setIsSuccess(rsp.getIsSuccess());
        rspBo.setRequestId(rsp.getRequestId());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private AlibabaEinvoiceCreatereqRequest buildReqParams(IfcReqCreateEinvoiceReqBO reqBo) {
        AlibabaEinvoiceCreatereqRequest req = new AlibabaEinvoiceCreatereqRequest();
        req.setApplyId(reqBo.getApplyId());
        req.setBusinessType(reqBo.getBusinessType());
        req.setDistributionTid(reqBo.getDistributionTid());
        req.setErpTid(reqBo.getErpTid());
        req.setInvoiceAmount(reqBo.getInvoiceAmount());
        req.setInvoiceKind(reqBo.getInvoiceKind());
        req.setInvoiceMemo(reqBo.getInvoiceMemo());
        req.setInvoiceTime(reqBo.getInvoiceTime());
        req.setInvoiceType(reqBo.getInvoiceType());
        req.setNormalInvoiceCode(reqBo.getNormalInvoiceCode());
        req.setNormalInvoiceNo(reqBo.getNormalInvoiceNo());
        req.setOutShopName(reqBo.getOutShopName());
        req.setPayeeAddress(reqBo.getPayeeAddress());
        req.setPayeeBankaccount(reqBo.getPayeeBankaccount());
        req.setPayeeChecker(reqBo.getPayeeChecker());
        req.setPayeeName(reqBo.getPayeeName());
        req.setPayeeOperator(reqBo.getPayeeOperator());
        req.setPayeePhone(reqBo.getPayeePhone());
        req.setPayeeReceiver(reqBo.getPayeeReceiver());
        req.setPayeeRegisterNo(reqBo.getPayeeRegisterNo());
        req.setPayerAddress(reqBo.getPayerAddress());
        req.setPayerBankaccount(reqBo.getPayerBankaccount());
        req.setPayerEmail(reqBo.getPayerEmail());
        req.setPayerName(reqBo.getPayerName());
        req.setPayerPhone(reqBo.getPayerPhone());
        req.setPayerRegisterNo(reqBo.getPayerRegisterNo());
        req.setPlatformCode(reqBo.getPlatformCode());
        req.setPlatformTid(reqBo.getPlatformTid());
        req.setRedNoticeNo(reqBo.getRedNoticeNo());
        req.setRequestRole(reqBo.getRequestRole());
        req.setSerialNo(reqBo.getSerialNo());
        req.setSumPrice(reqBo.getSumPrice());
        req.setSumTax(reqBo.getSumTax());
        ArrayList<AlibabaEinvoiceCreatereqRequest.InvoiceItem> invoiceItemsList = new ArrayList<AlibabaEinvoiceCreatereqRequest.InvoiceItem>();
        for (IfcEinvoiceItemBO itemBO : reqBo.getInvoiceItems()) {
            AlibabaEinvoiceCreatereqRequest.InvoiceItem invoiceItem = new AlibabaEinvoiceCreatereqRequest.InvoiceItem();
            invoiceItem.setAmount(itemBO.getAmount());
            invoiceItem.setItemName(itemBO.getItemName());
            invoiceItem.setItemNo(itemBO.getItemNo());
            invoiceItem.setPrice(itemBO.getPrice());
            invoiceItem.setQuantity(itemBO.getQuantity());
            invoiceItem.setRowType(itemBO.getRowType());
            invoiceItem.setSpecification(itemBO.getSpecification());
            invoiceItem.setSumPrice(itemBO.getSumPrice());
            invoiceItem.setTax(itemBO.getTax());
            invoiceItem.setTaxRate(itemBO.getTaxRate());
            invoiceItem.setUnit(itemBO.getUnit());
            invoiceItem.setAmount(itemBO.getAmount());
            invoiceItemsList.add(invoiceItem);
        }
        req.setInvoiceItems(invoiceItemsList);
        return req;
    }

    private String validateArg(IfcReqCreateEinvoiceReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getBusinessType()) {
            reqBo.setBusinessType(0L);
        }
        if (!StringUtils.hasText((String)reqBo.getPlatformCode())) {
            return "\u7535\u5546\u5e73\u53f0\u4ee3\u7801[platformCode]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPlatformTid())) {
            return "\u7535\u5546\u5e73\u53f0\u5bf9\u5e94\u7684\u4e3b\u8ba2\u5355\u53f7[platformTid]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getSerialNo())) {
            return "\u5f00\u7968\u6d41\u6c34\u53f7[seriaNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPayeeAddress())) {
            return "\u5f00\u7968\u65b9\u5730\u5740[payeeAddress]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPayeeName())) {
            return "\u5f00\u7968\u65b9\u540d\u79f0[payeeName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getInvoiceType())) {
            return "\u53d1\u7968(\u5f00\u7968)\u7c7b\u578b(blue/red)[invoiceType]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPayeeRegisterNo())) {
            return "\u6536\u6b3e\u65b9\u7a0e\u52a1\u767b\u8bb0\u8bc1\u53f7[payeeRegisterNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPayerName())) {
            return "\u4ed8\u6b3e\u65b9\u540d\u79f0[payerName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getInvoiceAmount())) {
            return "\u5f00\u7968\u91d1\u989d[invoiceAmount]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("red".equals(reqBo.getInvoiceType()) && new BigDecimal(reqBo.getInvoiceAmount()).compareTo(BigDecimal.ZERO) >= 0) {
            return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u5f00\u7968\u91d1\u989d[invoiceAmount]\u5e94\u5c0f\u4e8e0";
        }
        if ("blue".equals(reqBo.getInvoiceType()) && new BigDecimal(reqBo.getInvoiceAmount()).compareTo(BigDecimal.ZERO) <= 0) {
            return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u5f00\u7968\u91d1\u989d[invoiceAmount]\u5e94\u5927\u4e8e0";
        }
        if (!StringUtils.hasText((String)reqBo.getSumPrice())) {
            return "\u5408\u8ba1\u91d1\u989d[sumPrice]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("red".equals(reqBo.getInvoiceType()) && new BigDecimal(reqBo.getSumPrice()).compareTo(BigDecimal.ZERO) >= 0) {
            return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u5408\u8ba1\u91d1\u989d[sumPrice]\u5e94\u5c0f\u4e8e0";
        }
        if ("blue".equals(reqBo.getInvoiceType()) && new BigDecimal(reqBo.getSumPrice()).compareTo(BigDecimal.ZERO) <= 0) {
            return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u5408\u8ba1\u91d1\u989d[sumPrice]\u5e94\u5927\u4e8e0";
        }
        if (!StringUtils.hasText((String)reqBo.getSumTax())) {
            return "\u5408\u8ba1\u7a0e\u989d[sumTax]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("red".equals(reqBo.getInvoiceType()) && new BigDecimal(reqBo.getSumTax()).compareTo(BigDecimal.ZERO) >= 0) {
            return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u5408\u8ba1\u7a0e\u989d[sumTax]\u5e94\u5c0f\u4e8e0";
        }
        if ("blue".equals(reqBo.getInvoiceType()) && new BigDecimal(reqBo.getSumTax()).compareTo(BigDecimal.ZERO) <= 0) {
            return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u5408\u8ba1\u7a0e\u989d[sumTax]\u5e94\u5927\u4e8e0";
        }
        BigDecimal sumPrice = new BigDecimal(reqBo.getSumPrice());
        BigDecimal sumTax = new BigDecimal(reqBo.getSumTax());
        BigDecimal invoiceAmount = new BigDecimal(reqBo.getInvoiceAmount());
        if (invoiceAmount.compareTo(sumPrice.add(sumTax)) != 0) {
            return "\u5f00\u7968\u91d1\u989d[invoiceAmount]\u5e94\u7b49\u4e8e\u5408\u8ba1\u91d1\u989d[sumPrice]\u4e0e\u5408\u8ba1\u7a0e\u989d[sumTax]\u4e4b\u548c";
        }
        return CollectionUtils.isEmpty(reqBo.getInvoiceItems()) ? "\u7535\u5b50\u53d1\u7968\u660e\u7ec6[invoiceItems]\u4e0d\u80fd\u4e3a\u7a7a" : this.validateItems(reqBo.getInvoiceItems(), reqBo.getInvoiceType(), sumPrice, sumTax);
    }

    private String validateItems(List<IfcEinvoiceItemBO> invoiceItems, String invoiceType, BigDecimal invoiceSumPrice, BigDecimal invoiceSumTax) {
        BigDecimal totalSumPrice = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (IfcEinvoiceItemBO itemBo : invoiceItems) {
            if (!StringUtils.hasText((String)itemBo.getItemName())) {
                return "\u53d1\u7968\u9879\u76ee\u540d\u79f0[itemName]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!StringUtils.hasText((String)itemBo.getRowType())) {
                return "\u53d1\u7968\u884c\u6027\u8d28[rowType]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if ("1".equals(itemBo.getRowType())) {
                itemBo.setPrice(null);
                itemBo.setQuantity(null);
                itemBo.setUnit(null);
            } else if (!"1".equals(itemBo.getRowType())) {
                if (!StringUtils.hasText((String)itemBo.getPrice())) {
                    return "\u975e\u6298\u6263\u884c\u7684\u5355\u4ef7[price]\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (new BigDecimal(itemBo.getPrice()).compareTo(BigDecimal.ZERO) < 0) {
                    return "\u5355\u4ef7[price]\u5e94\u4e3a\u6b63\u6570";
                }
                if (!StringUtils.hasText((String)itemBo.getQuantity())) {
                    return "\u975e\u6298\u6263\u884c\u7684\u6570\u91cf[quantity]\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if ("red".equals(invoiceType) && new BigDecimal(itemBo.getQuantity()).compareTo(BigDecimal.ZERO) >= 0) {
                    return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u6570\u91cf[quantity]\u5e94\u5c0f\u4e8e0";
                }
                if ("blue".equals(invoiceType) && new BigDecimal(itemBo.getQuantity()).compareTo(BigDecimal.ZERO) <= 0) {
                    return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u6570\u91cf[quantity]\u5e94\u5927\u4e8e0";
                }
                if (!StringUtils.hasText((String)itemBo.getUnit())) {
                    return "\u975e\u6298\u6263\u884c\u7684\u5355\u4f4d[unit]\u4e0d\u80fd\u4e3a\u7a7a";
                }
            }
            if (!StringUtils.hasText((String)itemBo.getSumPrice())) {
                return "\u603b\u4ef7[sumPrice]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if ("red".equals(invoiceType) && new BigDecimal(itemBo.getQuantity()).compareTo(BigDecimal.ZERO) >= 0) {
                return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u603b\u4ef7[sumPrice]\u5e94\u5c0f\u4e8e0";
            }
            if ("blue".equals(invoiceType) && new BigDecimal(itemBo.getQuantity()).compareTo(BigDecimal.ZERO) <= 0) {
                return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u603b\u4ef7[sumPrice]\u5e94\u5927\u4e8e0";
            }
            if (!StringUtils.hasText((String)itemBo.getTax())) {
                return "\u7a0e\u989d[tax]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if ("red".equals(invoiceType) && new BigDecimal(itemBo.getTax()).compareTo(BigDecimal.ZERO) >= 0) {
                return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u7a0e\u989d[tax]\u5e94\u5c0f\u4e8e0";
            }
            if ("blue".equals(invoiceType) && new BigDecimal(itemBo.getTax()).compareTo(BigDecimal.ZERO) <= 0) {
                return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u7a0e\u989d[tax]\u5e94\u5927\u4e8e0";
            }
            if (!StringUtils.hasText((String)itemBo.getAmount())) {
                return "\u4ef7\u7a0e\u5408\u8ba1[amount]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if ("red".equals(invoiceType) && new BigDecimal(itemBo.getAmount()).compareTo(BigDecimal.ZERO) >= 0) {
                return "\u5f53\u5f00\u7ea2\u7968\u65f6\uff0c\u4ef7\u7a0e\u5408\u8ba1[amount]\u5e94\u5c0f\u4e8e0";
            }
            if ("blue".equals(invoiceType) && new BigDecimal(itemBo.getAmount()).compareTo(BigDecimal.ZERO) <= 0) {
                return "\u5f53\u5f00\u84dd\u7968\u65f6\uff0c\u4ef7\u7a0e\u5408\u8ba1[amount]\u5e94\u5927\u4e8e0";
            }
            BigDecimal sumPrice = new BigDecimal(itemBo.getSumPrice());
            BigDecimal tax = new BigDecimal(itemBo.getTax());
            BigDecimal amount = new BigDecimal(itemBo.getAmount());
            if (amount.compareTo(sumPrice.add(tax)) != 0) {
                return "\u660e\u7ec6\u9879\u76ee[" + itemBo.getItemName() + "]\u7684\u4ef7\u7a0e\u5408\u8ba1[amount]\u5e94\u7b49\u4e8e\u603b\u4ef7[sumPrice]\u4e0e\u7a0e\u989d[tax]\u4e4b\u548c";
            }
            if (!StringUtils.hasText((String)itemBo.getTaxRate())) {
                return "\u7a0e\u7387[taxRate]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!IfcEinvoiceConstants.TAX_RATE_COL.contains(itemBo.getTaxRate())) {
                return "\u7a0e\u7387[taxRate]\u53ea\u80fd\u4e3a0\u62160.03\u62160.04\u62160.06\u62160.11\u62160.13\u62160.17";
            }
            totalSumPrice = totalSumPrice.add(new BigDecimal(itemBo.getSumPrice()));
            totalTax = totalTax.add(new BigDecimal(itemBo.getTax()));
        }
        if (totalSumPrice.compareTo(invoiceSumPrice) != 0) {
            return "\u5f00\u7968\u5408\u8ba1\u91d1\u989d\u4e0e\u660e\u7ec6\u884c\u6240\u6709\u91d1\u989d\u52a0\u8d77\u6765\u8981\u4e00\u81f4";
        }
        if (totalTax.compareTo(invoiceSumTax) != 0) {
            return "\u5f00\u7968\u5408\u8ba1\u7a0e\u989d\u4e0e\u660e\u7ec6\u884c\u6240\u6709\u7a0e\u989d\u52a0\u8d77\u6765\u8981\u4e00\u81f4";
        }
        return null;
    }
}

