/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.external.service.einvoice.impl;

import com.alibaba.fastjson.JSON;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.AlibabaEinvoiceCreateResultGetRequest;
import com.taobao.api.response.AlibabaEinvoiceCreateResultGetResponse;
import com.tydic.pfsc.external.api.einvoice.IfcGetEinvoiceCreateResultIntfService;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceItemBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcEinvoiceResultBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcGetEinvoiceCreateResultReqBO;
import com.tydic.pfsc.external.api.einvoice.bo.IfcGetEinvoiceCreateResultRspBO;
import com.tydic.pfsc.external.common.einvoice.base.IfcEinvoiceTaoBaoClient;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ifcGetEinvoiceCreateResultService")
public class IfcGetEinvoiceCreateResultIntfServiceImpl
implements IfcGetEinvoiceCreateResultIntfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcGetEinvoiceCreateResultIntfServiceImpl.class);

    @Override
    public IfcGetEinvoiceCreateResultRspBO getEinvoiceCreateResult(IfcGetEinvoiceCreateResultReqBO reqBo) {
        AlibabaEinvoiceCreateResultGetResponse rsp;
        LOGGER.debug("\u83b7\u53d6\u5f00\u7968\u7ed3\u679c\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        IfcGetEinvoiceCreateResultRspBO rspBo = new IfcGetEinvoiceCreateResultRspBO();
        String validateArgStr = this.validateArg(reqBo);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBo.setInvoiceResultList(new ArrayList<IfcEinvoiceResultBO>());
            rspBo.setCode("7777");
            rspBo.setMsg(validateArgStr);
            rspBo.setSubCode("7777");
            rspBo.setSubMsg(validateArgStr);
            rspBo.setRespCode("7777");
            rspBo.setRespDesc(validateArgStr);
            return rspBo;
        }
        DefaultTaobaoClient client = IfcEinvoiceTaoBaoClient.getInstance();
        String sessionKey = IfcEinvoiceTaoBaoClient.getSessionKey();
        AlibabaEinvoiceCreateResultGetRequest req = this.buildReqParams(reqBo);
        LOGGER.debug("\u7ec4\u88c5\u540e\u8c03\u7528taobao\u83b7\u53d6\u5f00\u7968\u7ed3\u679c\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        try {
            rsp = (AlibabaEinvoiceCreateResultGetResponse)client.execute((TaobaoRequest)req, sessionKey);
            LOGGER.debug("\u8c03\u7528taobao\u83b7\u53d6\u5f00\u7968\u7ed3\u679c\u670d\u52a1\u54cd\u5e94\u51fa\u53c2\uff1a{}", (Object)rsp.getBody());
            if (rsp.getSubMsg() != null) {
                rspBo.setSubMsg(rsp.getSubMsg());
            }
        }
        catch (ApiException e) {
            rspBo.setInvoiceResultList(new ArrayList<IfcEinvoiceResultBO>());
            rspBo.setCode(e.getErrCode());
            rspBo.setMsg(e.getErrMsg());
            rspBo.setSubCode(e.getSubErrCode());
            rspBo.setSubMsg(e.getSubErrMsg());
            rspBo.setRespCode("0002");
            rspBo.setRespDesc(e.getSubErrMsg());
            return rspBo;
        }
        return this.buildRspParams(rspBo, rsp);
    }

    private IfcGetEinvoiceCreateResultRspBO buildRspParams(IfcGetEinvoiceCreateResultRspBO rspBo, AlibabaEinvoiceCreateResultGetResponse rsp) {
        ArrayList<IfcEinvoiceResultBO> einvoiceResultList = new ArrayList<IfcEinvoiceResultBO>();
        if (null != rsp && !CollectionUtils.isEmpty((Collection)rsp.getInvoiceResultList())) {
            for (AlibabaEinvoiceCreateResultGetResponse.InvoiceResult invoiceResult : rsp.getInvoiceResultList()) {
                IfcEinvoiceResultBO einvoiceResult = new IfcEinvoiceResultBO();
                einvoiceResult.setInvoiceDate(invoiceResult.getInvoiceDate());
                einvoiceResult.setPlatformCode(invoiceResult.getPlatformCode());
                einvoiceResult.setStatus(invoiceResult.getStatus());
                einvoiceResult.setFilePath(invoiceResult.getFilePath());
                einvoiceResult.setInvoiceAmount(invoiceResult.getInvoiceAmount());
                einvoiceResult.setCiphertext(invoiceResult.getCiphertext());
                einvoiceResult.setErpTid(invoiceResult.getErpTid());
                einvoiceResult.setFileDataType(invoiceResult.getFileDataType());
                einvoiceResult.setInvoiceNo(invoiceResult.getInvoiceNo());
                einvoiceResult.setSerialNo(invoiceResult.getSerialNo());
                einvoiceResult.setAntiFakeCode(invoiceResult.getAntiFakeCode());
                einvoiceResult.setDeviceNo(invoiceResult.getDeviceNo());
                einvoiceResult.setInvoiceCode(invoiceResult.getInvoiceCode());
                einvoiceResult.setPlatformTid(invoiceResult.getPlatformTid());
                einvoiceResult.setBizErrorMsg(invoiceResult.getBizErrorMsg());
                einvoiceResult.setBizErrorCode(invoiceResult.getBizErrorCode());
                einvoiceResult.setInvoiceType(invoiceResult.getInvoiceType());
                einvoiceResult.setInvoiceKind(invoiceResult.getInvoiceKind());
                einvoiceResult.setNormalInvoiceCode(invoiceResult.getNormalInvoiceCode());
                einvoiceResult.setNormalInvoiceNo(invoiceResult.getNormalInvoiceNo());
                einvoiceResult.setPayeeOperator(invoiceResult.getPayeeOperator());
                einvoiceResult.setPayeeReceiver(invoiceResult.getPayeeReceiver());
                einvoiceResult.setPayeeChecker(invoiceResult.getPayeeChecker());
                einvoiceResult.setPayerName(invoiceResult.getPayerName());
                einvoiceResult.setPayerRegisterNo(invoiceResult.getPayerRegisterNo());
                einvoiceResult.setPayerPhone(invoiceResult.getPayerPhone());
                einvoiceResult.setPayerAddress(invoiceResult.getPayerAddress());
                einvoiceResult.setPayerBankaccount(invoiceResult.getPayerBankaccount());
                einvoiceResult.setPayeeRegisterNo(invoiceResult.getPayeeRegisterNo());
                einvoiceResult.setInvoiceTime(invoiceResult.getInvoiceTime());
                if (!CollectionUtils.isEmpty((Collection)invoiceResult.getInvoiceItems())) {
                    ArrayList<IfcEinvoiceItemBO> einvoiceItemList = new ArrayList<IfcEinvoiceItemBO>();
                    for (AlibabaEinvoiceCreateResultGetResponse.InvoiceItem invoiceItem : invoiceResult.getInvoiceItems()) {
                        IfcEinvoiceItemBO einvoiceItem = new IfcEinvoiceItemBO();
                        einvoiceItem.setItemName(invoiceItem.getItemName());
                        einvoiceItem.setItemNo(invoiceItem.getItemNo());
                        einvoiceItem.setPrice(invoiceItem.getPrice());
                        einvoiceItem.setQuantity(invoiceItem.getQuantity());
                        einvoiceItem.setRowType(invoiceItem.getRowType());
                        einvoiceItem.setSpecification(invoiceItem.getSpecification());
                        einvoiceItem.setSumPrice(invoiceItem.getSumPrice());
                        einvoiceItem.setTax(invoiceItem.getTax());
                        einvoiceItem.setTaxRate(invoiceItem.getTaxRate());
                        einvoiceItem.setUnit(invoiceItem.getUnit());
                        einvoiceItem.setAmount(invoiceItem.getAmount());
                        einvoiceItem.setZeroRateFlag(invoiceItem.getZeroRateFlag());
                        einvoiceItem.setOuterId(invoiceItem.getOuterId());
                        einvoiceItem.setBizOrderId(invoiceItem.getBizOrderId());
                        einvoiceItem.setIsPostFeeRow(invoiceItem.getRowType());
                        einvoiceItemList.add(einvoiceItem);
                    }
                    einvoiceResult.setInvoiceItems(einvoiceItemList);
                }
                einvoiceResultList.add(einvoiceResult);
            }
        }
        rspBo.setInvoiceResultList(einvoiceResultList);
        rspBo.setRequestId(null == rsp ? null : rsp.getRequestId());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private AlibabaEinvoiceCreateResultGetRequest buildReqParams(IfcGetEinvoiceCreateResultReqBO reqBo) {
        AlibabaEinvoiceCreateResultGetRequest req = new AlibabaEinvoiceCreateResultGetRequest();
        req.setOutShopName(reqBo.getOutShopName());
        req.setPayeeRegisterNo(reqBo.getPayeeRegisterNo());
        req.setPlatformCode(reqBo.getPlatformCode());
        req.setPlatformTid(reqBo.getPlatformTid());
        req.setSerialNo(reqBo.getSerialNo());
        return req;
    }

    private String validateArg(IfcGetEinvoiceCreateResultReqBO reqBo) {
        boolean flag;
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPayeeRegisterNo())) {
            return "\u6536\u6b3e\u65b9\u7a0e\u52a1\u767b\u8bb0\u8bc1\u53f7[payeeRegisterNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        boolean bl = flag = !StringUtils.hasText((String)reqBo.getSerialNo()) && (!StringUtils.hasText((String)reqBo.getPlatformCode()) || !StringUtils.hasText((String)reqBo.getPlatformTid()));
        if (flag) {
            return "\u6d41\u6c34\u53f7(serialNo)\u548c\u7535\u5546\u5e73\u53f0\u4ee3\u7801\u3001\u7535\u5546\u8ba2\u5355\u53f7(platformCode,platformTid)\u5fc5\u987b\u586b\u5199\u5176\u4e2d\u4e00\u7ec4,serialNo\u4f18\u5148\u7ea7\u66f4\u9ad8";
        }
        return null;
    }
}

