/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.advice;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.picker.PickerClient;
import com.tydic.picker.constant.PickerConstants;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.enums.ResultCodeEnum;
import com.tydic.picker.result.PickerResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDataByPointCutAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SyncDataByPointCutAdvice.class);
    private PickerClient pickerClient;

    public SyncDataByPointCutAdvice(PickerClient pickerClient) {
        this.pickerClient = pickerClient;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object syncFlag;
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(16);
        Object rspObj = invocation.proceed();
        this.dealInArgument(invocation.getArguments(), fieldValueMap);
        if (log.isDebugEnabled()) {
            log.debug("\u5165\u53c2\u52a0\u5165map\uff1a{}", (Object)JSON.toJSONString(fieldValueMap));
        }
        if (ObjectUtil.isNotEmpty((Object)(syncFlag = ReflectUtil.getFieldValue((Object)rspObj, (String)"syncFlag"))) && PickerConstants.SYNC_FLAG_NO.equals(syncFlag)) {
            log.info("\u540c\u6b65\u6807\u8bc6\u6307\u5b9a\u672c\u6b21\u4e0d\u8fdb\u884c\u6570\u636e\u540c\u6b65\u64cd\u4f5c\u3002");
            return rspObj;
        }
        this.dealObject(rspObj, fieldValueMap);
        DataPickDTO pickDTO = DataPickDTO.builder().serviceCode(invocation.getMethod().getDeclaringClass().getName()).methodCode(invocation.getMethod().getName()).conditionParam(fieldValueMap).build();
        PickerResult result = this.pickerClient.execute(pickDTO);
        if (!ResultCodeEnum.SUCCESS.getCode().equals(result.getCode())) {
            log.error("\u540c\u6b65\u6570\u636e\u5931\u8d25\uff1a{}", (Object)result.getMessage());
        }
        return rspObj;
    }

    private void dealInArgument(Object[] arguments, Map<String, Object> map) throws Throwable {
        if (arguments != null) {
            for (Object arg : arguments) {
                this.dealObject(arg, map);
            }
        }
    }

    private void dealObject(Object dealObject, Map<String, Object> fieldValueMap) throws Throwable {
        List<Field> fields = SyncDataByPointCutAdvice.getAllField(dealObject.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            String fieldName = f.getName();
            if (null == f.get(dealObject)) continue;
            Object fieldValue = f.get(dealObject);
            fieldValueMap.put(fieldName, fieldValue);
        }
    }

    private static List<Field> getAllField(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

