package com.tydic.picker.properties;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @ClassName PickerProperties
 * @Description 数据同步配置
 * @Author liugs
 * @Date 2022/8/16 10:27
 */
@Data
@ConfigurationProperties(prefix = "picker.client")
public class PickerProperties {

    /**
     * 业务中心编码
     */
    private String busiCode;
    /**
     * 切点包路径，多个使用英文逗号[,]分隔
     */
    private String pointcutPackage;
    /**
     * 分片执行线程池大小
     */
    private int partitionPoolSize = 10;
    /**
     * 分片大小
     */
    private Integer pageSize = 100;
}
