/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.service.imp;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.dto.PickerRecordDTO;
import com.tydic.picker.enums.ConstantEnum;
import com.tydic.picker.enums.ResultCodeEnum;
import com.tydic.picker.result.PickerResult;
import com.tydic.picker.service.DataSyncService;
import com.tydic.picker.utils.ElasticsearchUtil;
import com.tydic.picker.utils.Sequence;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSyncServiceImpl
implements DataSyncService {
    private static final Logger log = LoggerFactory.getLogger(DataSyncServiceImpl.class);
    private static final String DOCUMENT_ID = "DOCUMENT_ID";
    private JdbcTemplate jdbcTemplate;
    private ElasticsearchUtil elasticsearchUtil;

    public DataSyncServiceImpl(JdbcTemplate jdbcTemplate, ElasticsearchUtil elasticsearchUtil) {
        this.jdbcTemplate = jdbcTemplate;
        this.elasticsearchUtil = elasticsearchUtil;
    }

    @Override
    public PickerResult doSync(DataPickDTO dto) {
        log.info("==\u5f00\u59cb\u91c7\u96c6\u6570\u636e\u5e76\u540c\u6b65ES");
        PickerResult result = new PickerResult(ResultCodeEnum.SUCCESS);
        Long recordId = null;
        try {
            recordId = this.createSyncRecord(dto);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u5165\u5e93\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        String errorMessage = null;
        try {
            JSONObject esData = this.getMappedData(dto);
            log.debug("\u6839\u636e\u6620\u5c04\u5173\u7cfb\u7684\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a{}", (Object)esData.toJSONString());
            switch (dto.getEventTypeEnum()) {
                case CREATE: {
                    this.createDoc(esData, dto);
                    break;
                }
                case UPDATE: {
                    this.updateDoc(esData, dto);
                    break;
                }
                case DELETE: {
                    this.deleteDoc(esData, dto);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.debug("\u540c\u6b65ES\u6570\u636e\u5f02\u5e38\uff1a{}", (Throwable)e);
            errorMessage = "\u540c\u6b65ES\u6570\u636e\u5f02\u5e38\uff1a" + e;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)errorMessage)) {
                this.updateRecord(recordId, ConstantEnum.PickerRecordStatusEnum.SUCCESS, ConstantEnum.PickerRecordStatusEnum.SUCCESS.getDesc());
            } else {
                this.updateRecord(recordId, ConstantEnum.PickerRecordStatusEnum.FAIL, errorMessage);
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u72b6\u6001\u66f4\u65b0\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            result.buildFail(errorMessage);
        }
        log.info("==\u91c7\u96c6\u6570\u636e\u5e76\u540c\u6b65ES\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    private void createDoc(JSONObject esData, DataPickDTO dto) {
        this.elasticsearchUtil.addDocument(dto.getIndexName(), esData.remove((Object)DOCUMENT_ID).toString(), esData);
    }

    private void updateDoc(JSONObject esData, DataPickDTO dto) {
        this.elasticsearchUtil.updateDoc(dto.getIndexName(), esData.remove((Object)DOCUMENT_ID).toString(), esData);
    }

    private void deleteDoc(JSONObject esData, DataPickDTO dto) {
        this.elasticsearchUtil.deleteDocById(dto.getIndexName(), esData.getString(DOCUMENT_ID));
    }

    private Long createSyncRecord(DataPickDTO dto) {
        Long id = Sequence.nextId();
        PickerRecordDTO recordPo = new PickerRecordDTO();
        BeanUtils.copyProperties((Object)dto, (Object)recordPo);
        recordPo.setId(id);
        recordPo.setEventType(dto.getEventTypeEnum().getEventType());
        recordPo.setStartTime(new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        recordPo.setStatusDesc(ConstantEnum.PickerRecordStatusEnum.INIT.getDesc());
        recordPo.setDynamicSql(StringUtils.isEmpty((CharSequence)dto.getDynamicSql()) ? null : Base64Encoder.encode((CharSequence)dto.getDynamicSql()));
        String dynamicSql = ConstantEnum.DynamicSqlEnum.INSERT.getDynamicSql((Map)JSON.parseObject((String)JSON.toJSONString((Object)recordPo), Map.class));
        log.debug("\u8bb0\u5f55\u6570\u636e\u540c\u6b65SQL\uff1a{}", (Object)dynamicSql);
        if (1 > this.jdbcTemplate.update(dynamicSql)) {
            log.error("\u8bb0\u5f55\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
            return null;
        }
        return id;
    }

    private void updateRecord(Long recordId, ConstantEnum.PickerRecordStatusEnum statusEnum, String desc) {
        PickerRecordDTO recordPo = new PickerRecordDTO();
        recordPo.setId(recordId);
        recordPo.setStatus(statusEnum.getState());
        recordPo.setStatusDesc(desc);
        recordPo.setFinishTime(new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        String dynamicSql = ConstantEnum.DynamicSqlEnum.UPDATE.getDynamicSql((Map)JSON.parseObject((String)JSON.toJSONString((Object)recordPo), Map.class));
        log.debug("\u8bb0\u5f55\u6570\u636e\u540c\u6b65SQL\uff1a{}", (Object)dynamicSql);
        if (1 > this.jdbcTemplate.update(dynamicSql)) {
            log.error("\u66f4\u65b0\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
    }

    public JSONObject getMappedData(DataPickDTO dto) {
        JSONObject mappingRelJson = JSON.parseObject((String)dto.getMappingInfo());
        JSONObject mappedDataJson = new JSONObject(true);
        Object dynamicDataMap = JSON.parseObject((String)dto.getConditionParam());
        if (StringUtils.isEmpty((CharSequence)dto.getDynamicSql())) {
            for (Map.Entry entry : mappingRelJson.entrySet()) {
                mappedDataJson.put(entry.getValue().toString(), dynamicDataMap.get(entry.getKey()));
            }
        } else {
            String dynamicSql = ConstantEnum.DynamicSqlEnum.buildDynamicSql((String)dto.getDynamicSql(), (Map)dynamicDataMap);
            log.info("\u6267\u884c\u7684\u53d6\u503c\u52a8\u6001\u8bed\u53e5\u4e3a\uff1a{}", (Object)dynamicSql);
            dynamicDataMap = this.jdbcTemplate.queryForMap(dynamicSql);
            log.info("\u6267\u884c\u52a8\u6001\u8bed\u53e5\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dynamicDataMap));
            for (Map.Entry entry : mappingRelJson.entrySet()) {
                mappedDataJson.put(entry.getValue().toString(), dynamicDataMap.get(entry.getKey()));
            }
        }
        mappedDataJson.put(DOCUMENT_ID, dynamicDataMap.get(dto.getDocIdField()));
        return mappedDataJson;
    }
}

