/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.dto.DataSyncConfigDTO;
import com.tydic.picker.enums.ConstantEnum;
import com.tydic.picker.enums.DataEventTypeEnum;
import com.tydic.picker.enums.ResultCodeEnum;
import com.tydic.picker.publisher.PickerClientPublisher;
import com.tydic.picker.result.PickerResult;
import com.tydic.picker.service.DataSyncService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickerClient {
    private static final Logger log = LoggerFactory.getLogger(PickerClient.class);
    private static final String POINT = ".";
    private PickerClientPublisher publisher;
    private CacheClient cacheClient;
    private DataSyncService dataSyncService;

    public void init(PickerClientPublisher publisher, CacheClient cacheClient, DataSyncService dataSyncService) {
        this.publisher = publisher;
        this.cacheClient = cacheClient;
        this.dataSyncService = dataSyncService;
    }

    public void close() {
        this.publisher.close();
    }

    public PickerResult execute(DataPickDTO dto) {
        AtomicReference<PickerResult> pickerResult = new AtomicReference<PickerResult>(new PickerResult(ResultCodeEnum.SUCCESS));
        String cacheKey = dto.getServiceCode() + POINT + dto.getMethodCode();
        Object cacheInfo = this.cacheClient.get(cacheKey);
        if (ObjectUtil.isEmpty((Object)cacheInfo)) {
            log.info("\u65b9\u6cd5\uff1a[{}]\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u540c\u6b65\u4fe1\u606f", (Object)cacheKey);
            return pickerResult.get();
        }
        JSONArray syncConfigArray = JSON.parseArray((String)String.valueOf(cacheInfo));
        syncConfigArray.forEach(item -> {
            DataSyncConfigDTO configDTO = (DataSyncConfigDTO)JSON.parseObject((String)item.toString(), DataSyncConfigDTO.class);
            dto.setBusiCode(configDTO.getBusiCode());
            dto.setIndexName(configDTO.getIndexName());
            dto.setDynamicSql(configDTO.getDataFilter());
            dto.setMappingInfo(configDTO.getMappingInfo());
            dto.setEventTypeEnum(DataEventTypeEnum.acquireByValue((String)configDTO.getEventType()));
            dto.setDocIdField(configDTO.getDocValueFiled());
            dto.setSyncType(Integer.valueOf(configDTO.getSyncType()));
            if (ConstantEnum.SyncTypeEnum.SYNC.getSyncType().equals(configDTO.getSyncType())) {
                pickerResult.set(this.dataSyncService.doSync(dto));
            } else {
                this.publisher.publish(dto);
            }
        });
        return pickerResult.get();
    }
}

