package com.tydic.picker.disruptor.subscriber;

import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.service.DataSyncService;
import com.tydic.picker.subscriber.ExecutorSubscriber;

import java.util.Collection;
import java.util.Optional;

/**
 * @ClassName DataSyncExecutorSubscriber
 * @Description 数据同步执行器订阅者
 * @Author liugs
 * @Date 2022/8/15 16:32
 */
public class DataSyncExecutorSubscriber implements ExecutorSubscriber<DataPickDTO> {

    private DataSyncService dataSyncService;

    public DataSyncExecutorSubscriber(DataSyncService dataSyncService) {
        this.dataSyncService = dataSyncService;
    }

    @Override
    public void executor(Collection<DataPickDTO> dataList) {
        for (DataPickDTO dataSyncDTO : dataList) {
            Optional.ofNullable(dataSyncService)
                    .ifPresent(dataSyncService -> {
                        synchronized (dataSyncService) {
                            dataSyncService.doSync(dataSyncDTO);
                        }
                    });
        }
    }
}
