/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.task;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.enums.ResultCodeEnum;
import com.tydic.picker.task.PartitionResult;
import com.tydic.picker.utils.DynamicSqlUtil;
import com.tydic.picker.utils.ElasticsearchUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionTask
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(PartitionTask.class);
    private Long recordId;
    private DataPickDTO dto;
    private ElasticsearchUtil elasticsearchUtil;
    private DynamicSqlUtil dynamicSqlUtil;
    private List<Map<String, Object>> mainDataList;
    private Integer pageNo;

    @Override
    public Object call() {
        PartitionResult result = new PartitionResult();
        result.setCode(ResultCodeEnum.FAIL.getCode());
        try {
            for (Map<String, Object> mainData : this.mainDataList) {
                JSONObject esData = this.dynamicSqlUtil.getMappedDataForBatch(this.dto, mainData);
                log.debug("\u6839\u636e\u6620\u5c04\u5173\u7cfb\u7684\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)esData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                if (ObjectUtil.isNotEmpty((Object)esData.get((Object)"DOCUMENT_ID"))) {
                    this.elasticsearchUtil.doSyncByEventType(this.dto.getEventTypeEnum(), this.dto.getIndexName(), esData);
                    continue;
                }
                result.setMessage(String.format("\u6839\u636e\u914d\u7f6e\u7684\u6587\u6863ID\u53d6\u503c\u5b57\u6bb5[%s]\u672a\u83b7\u53d6\u5230\u6587\u6863ID", this.dto.getDocIdField()));
            }
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES\u6570\u636e\u5f02\u5e38\uff1a");
            e.printStackTrace();
            result.setMessage(String.format("\u540c\u6b65\u4efb\u52a1ID\u3010%d\u3011\uff0c\u7b2c\u3010%d\u3011\u5206\u7247\u540c\u6b65\u53d1\u751f\u5f02\u5e38\uff1a\u3010%s\u3011", this.recordId, this.pageNo, e.getMessage()));
            return result;
        }
        result.setCode(ResultCodeEnum.SUCCESS.getCode());
        return result;
    }

    PartitionTask(Long recordId, DataPickDTO dto, ElasticsearchUtil elasticsearchUtil, DynamicSqlUtil dynamicSqlUtil, List<Map<String, Object>> mainDataList, Integer pageNo) {
        this.recordId = recordId;
        this.dto = dto;
        this.elasticsearchUtil = elasticsearchUtil;
        this.dynamicSqlUtil = dynamicSqlUtil;
        this.mainDataList = mainDataList;
        this.pageNo = pageNo;
    }

    public static PartitionTaskBuilder builder() {
        return new PartitionTaskBuilder();
    }

    public static class PartitionTaskBuilder {
        private Long recordId;
        private DataPickDTO dto;
        private ElasticsearchUtil elasticsearchUtil;
        private DynamicSqlUtil dynamicSqlUtil;
        private List<Map<String, Object>> mainDataList;
        private Integer pageNo;

        PartitionTaskBuilder() {
        }

        public PartitionTaskBuilder recordId(Long recordId) {
            this.recordId = recordId;
            return this;
        }

        public PartitionTaskBuilder dto(DataPickDTO dto) {
            this.dto = dto;
            return this;
        }

        public PartitionTaskBuilder elasticsearchUtil(ElasticsearchUtil elasticsearchUtil) {
            this.elasticsearchUtil = elasticsearchUtil;
            return this;
        }

        public PartitionTaskBuilder dynamicSqlUtil(DynamicSqlUtil dynamicSqlUtil) {
            this.dynamicSqlUtil = dynamicSqlUtil;
            return this;
        }

        public PartitionTaskBuilder mainDataList(List<Map<String, Object>> mainDataList) {
            this.mainDataList = mainDataList;
            return this;
        }

        public PartitionTaskBuilder pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return this;
        }

        public PartitionTask build() {
            return new PartitionTask(this.recordId, this.dto, this.elasticsearchUtil, this.dynamicSqlUtil, this.mainDataList, this.pageNo);
        }

        public String toString() {
            return "PartitionTask.PartitionTaskBuilder(recordId=" + this.recordId + ", dto=" + this.dto + ", elasticsearchUtil=" + this.elasticsearchUtil + ", dynamicSqlUtil=" + this.dynamicSqlUtil + ", mainDataList=" + this.mainDataList + ", pageNo=" + this.pageNo + ")";
        }
    }
}

