/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.dto.DataSyncConfigDTO;
import com.tydic.picker.enums.ConstantEnum;
import com.tydic.picker.enums.DataEventTypeEnum;
import com.tydic.picker.enums.ResultCodeEnum;
import com.tydic.picker.publisher.PickerClientPublisher;
import com.tydic.picker.result.PickerResult;
import com.tydic.picker.service.DataSyncService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickerClient {
    private static final Logger log = LoggerFactory.getLogger(PickerClient.class);
    private static final String POINT = ".";
    private static final String UNDERSCORE = "_";
    private static final String PICKER_CONFIG_NO = "pickerConfigNo";
    private Boolean syncFinishFlag;
    private PickerClientPublisher publisher;
    private CacheClient cacheClient;
    private DataSyncService dataSyncService;

    public void init(PickerClientPublisher publisher, CacheClient cacheClient, DataSyncService dataSyncService) {
        this.publisher = publisher;
        this.cacheClient = cacheClient;
        this.dataSyncService = dataSyncService;
    }

    public void close() {
        this.publisher.close();
    }

    public PickerResult execute(DataPickDTO dto) {
        JSONArray syncConfigArray;
        Object cacheInfo;
        AtomicReference<PickerResult> pickerResult = new AtomicReference<PickerResult>(new PickerResult(ResultCodeEnum.SUCCESS));
        StringBuilder cacheKeyBuilder = new StringBuilder();
        cacheKeyBuilder.append(dto.getServiceCode()).append(POINT).append(dto.getMethodCode());
        Object pickerConfigNo = dto.getConditionParam().get(PICKER_CONFIG_NO);
        if (ObjectUtil.isNotEmpty(pickerConfigNo)) {
            cacheKeyBuilder.append(UNDERSCORE).append(pickerConfigNo);
        }
        if (ObjectUtil.isEmpty((Object)(cacheInfo = this.cacheClient.get(cacheKeyBuilder.toString())))) {
            log.info("\u65b9\u6cd5\uff1a[{}]\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u540c\u6b65\u4fe1\u606f", (Object)cacheKeyBuilder);
            return pickerResult.get();
        }
        try {
            syncConfigArray = JSON.parseArray((String)String.valueOf(cacheInfo));
        }
        catch (Exception e) {
            log.info("\u89e3\u6790\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u4e3a\u6807\u51c6JSON\u683c\u5f0f");
            pickerResult.get().buildFail("\u89e3\u6790\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u4e3a\u6807\u51c6JSON\u683c\u5f0f");
            return pickerResult.get();
        }
        syncConfigArray.forEach(item -> {
            Object traversalObj;
            this.syncFinishFlag = false;
            DataSyncConfigDTO configDTO = (DataSyncConfigDTO)JSON.parseObject((String)item.toString(), DataSyncConfigDTO.class);
            dto.setBusiCode(configDTO.getBusiCode());
            dto.setIndexName(configDTO.getIndexName());
            dto.setDynamicSql(configDTO.getDataFilter());
            dto.setMappingInfo(configDTO.getMappingInfo());
            dto.setEventTypeEnum(DataEventTypeEnum.acquireByValue((String)configDTO.getEventType()));
            dto.setDocIdField(configDTO.getDocValueFiled());
            dto.setSyncType(Integer.valueOf(configDTO.getSyncType()));
            dto.setSubQuery(configDTO.getSubQuery());
            Map conditionParam = dto.getConditionParam();
            if (StringUtils.isNotEmpty((CharSequence)configDTO.getTraversalObjField()) && ObjectUtil.isNotEmpty(traversalObj = conditionParam.get(configDTO.getTraversalObjField()))) {
                JSONArray traversalArray = JSON.parseArray((String)JSON.toJSONString(traversalObj));
                for (int i = 0; i < traversalArray.size(); ++i) {
                    Map traversalMap = (Map)JSON.parseObject((String)traversalArray.getString(i), Map.class);
                    traversalMap.putAll(conditionParam);
                    dto.setConditionParam(traversalMap);
                    DataPickDTO eventDto = (DataPickDTO)JSON.parseObject((String)JSON.toJSONString((Object)dto), DataPickDTO.class);
                    if (ConstantEnum.SyncTypeEnum.SYNC.getSyncType().equals(configDTO.getSyncType())) {
                        pickerResult.set(this.dataSyncService.doSync(eventDto));
                        continue;
                    }
                    this.publisher.publish(eventDto);
                }
                this.syncFinishFlag = true;
            }
            if (!this.syncFinishFlag.booleanValue()) {
                if (ConstantEnum.SyncTypeEnum.SYNC.getSyncType().equals(configDTO.getSyncType())) {
                    pickerResult.set(this.dataSyncService.doSync(dto));
                } else {
                    this.publisher.publish(dto);
                }
            }
        });
        return pickerResult.get();
    }
}

