package com.tydic.picker.disruptor;

import com.tydic.picker.DisruptorProviderManage;
import com.tydic.picker.disruptor.executor.DataSyncConsumerExecutor.DataSyncExecutorFactory;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.disruptor.subscriber.DataSyncExecutorSubscriber;
import com.tydic.picker.provider.DisruptorProvider;
import com.tydic.picker.service.DataSyncService;
import com.tydic.picker.publisher.PickerClientPublisher;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

/**
 * @ClassName PickerDisruptorPublisher
 * @Description 数据同步 发布者
 * @Author liugs
 * @Date 2022/8/15 16:05
 */
public class PickerClientDisruptorClientPublisher implements PickerClientPublisher {

    private static final PickerClientDisruptorClientPublisher INSTANCE = new PickerClientDisruptorClientPublisher();

    private DisruptorProviderManage<Collection<DataPickDTO>> providerManage;

    /**
     * Gets instance.
     *
     * @return the instance
     */
    public static PickerClientDisruptorClientPublisher getInstance() {
        return INSTANCE;
    }

    public void start(DataSyncService dataSyncService) {
        DataSyncExecutorFactory factory = new DataSyncExecutorFactory();
        factory.setSubscribers(new DataSyncExecutorSubscriber(dataSyncService));
        providerManage = new DisruptorProviderManage<>(factory);
        providerManage.startup();
    }

    @Override
    public void publish(final DataPickDTO data) {
        DisruptorProvider<Collection<DataPickDTO>> provider = providerManage.getProvider();
        provider.onData(Collections.singleton(data));
    }

    @Override
    public void publish(final Collection<? extends DataPickDTO> dataList) {
        DisruptorProvider<Collection<DataPickDTO>> provider = providerManage.getProvider();
        provider.onData(dataList.stream().map(DataPickDTO.class::cast).collect(Collectors.toList()));

    }

    @Override
    public void close() {
        providerManage.getProvider().shutdown();
    }

}
