package com.tydic.picker.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName DynamicUtil
 * @Description
 * @Author liugs
 * @Date 2022/8/25 11:52
 */
public class DynamicUtil {

    /** 占位符匹配正则 */
    public static final Pattern PLACE_PATTERN = Pattern.compile("(\\$\\{)([\\w]+)(})");

    /**
     * 描述 构建动态 Sql
     * @param dynamicSql
     * @param paramMap
     * @return java.lang.String
     * @author liugs
     * @date 2022/8/25 11:54
     */
    public static String buildDynamicSql(String dynamicSql, Map<String, Object> paramMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PLACE_PATTERN.matcher(dynamicSql);
        while (matcher.find()) {
            String group = matcher.group(2);
            if (paramMap.get(group) == null) {
                matcher.appendReplacement(stringBuffer, "null");
                continue;
            }
            matcher.appendReplacement(stringBuffer, "'" + paramMap.get(group).toString() + "'");
        }
        matcher.appendTail(stringBuffer);

        return stringBuffer.toString().trim();
    }
}
